/*
 * Decompiled with CFR 0.152.
 */
package org.devefx.validator.beans.factory;

import org.devefx.validator.beans.BeansException;
import org.devefx.validator.util.StringUtils;

public class NoSuchBeanException
extends BeansException {
    private static final long serialVersionUID = -229370412918880486L;
    private String beanName;
    private Class<?> beanType;

    public NoSuchBeanException(String name) {
        super("No bean named '" + name + "' is defined");
        this.beanName = name;
    }

    public NoSuchBeanException(String name, String message) {
        super("No bean named '" + name + "' is defined: " + message);
        this.beanName = name;
    }

    public NoSuchBeanException(Class<?> type) {
        super("No qualifying bean of type [" + type.getName() + "] is defined");
        this.beanType = type;
    }

    public NoSuchBeanException(Class<?> type, String message) {
        super("No qualifying bean of type [" + type.getName() + "] is defined: " + message);
        this.beanType = type;
    }

    public NoSuchBeanException(Class<?> type, String dependencyDescription, String message) {
        super("No qualifying bean of type [" + type.getName() + "] found for dependency" + (StringUtils.hasLength(dependencyDescription) ? " [" + dependencyDescription + "]" : "") + ": " + message);
        this.beanType = type;
    }

    public String getBeanName() {
        return this.beanName;
    }

    public Class<?> getBeanType() {
        return this.beanType;
    }

    public int getNumberOfBeansFound() {
        return 0;
    }
}

