/*
 * Decompiled with CFR 0.152.
 */
package org.devefx.validator.beans.factory;

import java.util.Arrays;
import java.util.Collection;
import org.devefx.validator.beans.BeansException;
import org.devefx.validator.util.StringUtils;

public class NoUniqueBeanException
extends BeansException {
    private static final long serialVersionUID = -7811666048083937858L;
    private Class<?> beanType;
    private int numberOfBeansFound;

    public NoUniqueBeanException(Class<?> type, int numberOfBeansFound, String message) {
        super("No bean named '" + type.getName() + "' is defined");
        this.beanType = type;
        this.numberOfBeansFound = numberOfBeansFound;
    }

    public NoUniqueBeanException(Class<?> type, Collection<String> beanNamesFound) {
        this(type, beanNamesFound.size(), "expected single matching bean but found " + beanNamesFound.size() + ": " + StringUtils.collectionToCommaDelimitedString(beanNamesFound));
    }

    public NoUniqueBeanException(Class<?> type, String ... beanNamesFound) {
        this(type, Arrays.asList(beanNamesFound));
    }

    public Class<?> getBeanType() {
        return this.beanType;
    }

    public int getNumberOfBeansFound() {
        return this.numberOfBeansFound;
    }
}

