/*
 * Decompiled with CFR 0.152.
 */
package org.devefx.validator.constraints;

import java.math.BigDecimal;
import java.math.BigInteger;
import org.devefx.validator.ConstraintValidator;
import org.devefx.validator.constraints.annotation.InitParam;
import org.devefx.validator.script.annotation.Script;
import org.devefx.validator.util.ObjectUtils;

@Script
public class DecimalMax
implements ConstraintValidator {
    @InitParam
    private BigDecimal maxValue;
    @InitParam
    private boolean inclusive;

    public DecimalMax(String maxValue) {
        this(maxValue, true);
    }

    public DecimalMax(String maxValue, boolean inclusive) {
        try {
            this.maxValue = new BigDecimal(maxValue);
        }
        catch (NumberFormatException nfe) {
            throw new IllegalArgumentException(String.valueOf(maxValue) + " does not represent a valid BigDecimal format.", nfe);
        }
        this.inclusive = inclusive;
    }

    @Override
    public boolean isValid(Object value) {
        Number numValue;
        if (ObjectUtils.isEmpty(value)) {
            return true;
        }
        if (value instanceof Number) {
            numValue = (Number)value;
        } else if (value instanceof String) {
            numValue = new BigDecimal((String)value);
        } else {
            throw new IllegalArgumentException("Unsupported of type [" + value.getClass().getName() + "]");
        }
        if (numValue instanceof Double) {
            if ((Double)numValue == Double.NEGATIVE_INFINITY) {
                return true;
            }
            if (Double.isNaN((Double)numValue) || (Double)numValue == Double.POSITIVE_INFINITY) {
                return false;
            }
        } else if (numValue instanceof Float) {
            if (((Float)numValue).floatValue() == Float.NEGATIVE_INFINITY) {
                return true;
            }
            if (Float.isNaN(((Float)numValue).floatValue()) || ((Float)numValue).floatValue() == Float.POSITIVE_INFINITY) {
                return false;
            }
        }
        int comparisonResult = numValue instanceof BigDecimal ? ((BigDecimal)numValue).compareTo(this.maxValue) : (numValue instanceof BigInteger ? new BigDecimal((BigInteger)numValue).compareTo(this.maxValue) : (numValue instanceof Long ? BigDecimal.valueOf(numValue.longValue()).compareTo(this.maxValue) : BigDecimal.valueOf(numValue.doubleValue()).compareTo(this.maxValue)));
        return this.inclusive ? comparisonResult <= 0 : comparisonResult < 0;
    }
}

