/*
 * Decompiled with CFR 0.152.
 */
package org.devefx.validator.constraints;

import java.math.BigDecimal;
import org.devefx.validator.ConstraintValidator;
import org.devefx.validator.constraints.annotation.InitParam;
import org.devefx.validator.script.annotation.Script;
import org.devefx.validator.util.ObjectUtils;

@Script
public class Digits
implements ConstraintValidator {
    @InitParam
    private int maxIntegerLength;
    @InitParam
    private int maxFractionLength;

    public Digits(int maxIntegerLength, int maxFractionLength) {
        this.maxIntegerLength = maxIntegerLength;
        this.maxFractionLength = maxFractionLength;
        this.validateParameters();
    }

    @Override
    public boolean isValid(Object value) {
        int fractionPartLength;
        Number num;
        if (ObjectUtils.isEmpty(value)) {
            return true;
        }
        if (value instanceof Number) {
            num = (Number)value;
        } else if (value instanceof String) {
            num = new BigDecimal((String)value);
        } else {
            throw new IllegalArgumentException("Unsupported of type [" + value.getClass().getName() + "]");
        }
        BigDecimal bigNum = num instanceof BigDecimal ? (BigDecimal)num : new BigDecimal(num.toString()).stripTrailingZeros();
        int integerPartLength = bigNum.precision() - bigNum.scale();
        int n = fractionPartLength = bigNum.scale() < 0 ? 0 : bigNum.scale();
        return this.maxIntegerLength >= integerPartLength && this.maxFractionLength >= fractionPartLength;
    }

    private void validateParameters() {
        if (this.maxIntegerLength < 0) {
            throw new IllegalArgumentException("The length of the integer part cannot be negative.");
        }
        if (this.maxFractionLength < 0) {
            throw new IllegalArgumentException("The length of the fraction part cannot be negative.");
        }
    }
}

