/*
 * Decompiled with CFR 0.152.
 */
package org.devefx.validator.constraints;

import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.devefx.validator.ConstraintValidator;
import org.devefx.validator.script.annotation.Script;

@Script
public class Email
implements ConstraintValidator {
    private static final String emailPattern = "^[a-zA-Z0-9.!#$%&'*+\\/=?^_`{|}~-]+@[a-zA-Z0-9](?:[a-zA-Z0-9-]{0,61}[a-zA-Z0-9])?(?:\\.[a-zA-Z0-9](?:[a-zA-Z0-9-]{0,61}[a-zA-Z0-9])?)*$";
    private static Map<String, RegExp> regExpMap = new HashMap<String, RegExp>();

    @Override
    public boolean isValid(Object value) {
        if (value == null) {
            return true;
        }
        String stringValue = value.toString();
        if (stringValue.length() == 0) {
            return true;
        }
        int splitPosition = stringValue.lastIndexOf("@");
        if (splitPosition < 0) {
            return false;
        }
        String name = stringValue.substring(0, splitPosition);
        String domain = stringValue.substring(splitPosition + 1);
        boolean valid = false;
        if ("163.com".equals(domain) || "126.com".equals(domain) || "yeah.net".equals(domain)) {
            valid = this.newRegExp("^[a-z][a-z0-9_]{5,17}$", 2).test(name);
        } else if ("qq.com".equals(domain) || "foxmail.com".equals(domain)) {
            valid = "qq.com".equals(domain) && this.newRegExp("^[1-9][0-9]{4,10}$").test(name);
            valid = valid || this.newRegExp("^[a-z][a-z0-9._-]{2,17}$", 2).test(name) && !this.newRegExp("([._-]){2,}").test(name);
        } else {
            valid = "sina.com".equals(domain) || "sina.cn".equals(domain) ? this.newRegExp("^[a-z0-9][a-z0-9_]{2,14}[a-z0-9]$").test(name) : ("sohu.com".equals(domain) ? this.newRegExp("^[a-z][a-zA-Z0-9_]{3,15}$").test(name) : ("gmail.com".equals(domain) ? this.newRegExp("^[a-z0-9][a-z0-9.]{4,28}[a-z0-9]$", 2).test(name) && !this.newRegExp("\\.{2,}").test(name) && (name.length() < 8 || this.newRegExp("[a-z]").test(name)) : ("outlook.com".equals(domain) || "hotmail.com".equals(domain) ? this.newRegExp("^[a-z][a-z0-9._-]{0,63}$", 2).test(name) && !this.newRegExp("\\.{2,}").test(name) : ("yahoo.com".equals(domain) || "yahoo.com.cn".equals(domain) || "yahoo.cn".equals(domain) ? this.newRegExp("^[a-z][a-z0-9._]{2,30}[a-z0-9]$", 2).test(name) && !this.newRegExp("_{2,}").test(name) && this.newRegExp("\\.").count(name) < 2 : Pattern.matches(emailPattern, stringValue)))));
        }
        return valid;
    }

    private RegExp newRegExp(String regex) {
        return this.newRegExp(regex, 0);
    }

    private RegExp newRegExp(String regex, int flags) {
        RegExp regExp = regExpMap.get(String.valueOf(regex) + "/" + flags);
        if (regExp == null) {
            regExp = new RegExp(regex, flags);
            regExpMap.put(String.valueOf(regex) + "/" + flags, regExp);
        }
        return regExp;
    }

    static class RegExp {
        private Pattern pattern;

        public RegExp(String regex, int flags) {
            this.pattern = Pattern.compile(regex, flags);
        }

        public boolean test(String value) {
            return this.pattern.matcher(value).find();
        }

        public int count(String value) {
            int count = 0;
            Matcher matcher = this.pattern.matcher(value);
            while (matcher.find()) {
                ++count;
            }
            return count;
        }
    }
}

