/*
 * Decompiled with CFR 0.152.
 */
package org.devefx.validator.constraints;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.devefx.validator.ConstraintValidator;
import org.devefx.validator.constraints.annotation.InitParam;
import org.devefx.validator.script.annotation.Script;
import org.devefx.validator.util.ObjectUtils;

@Script
public class Future
implements ConstraintValidator {
    private static final String DEFAULT_PATTERN = "yyyy-MM-dd HH:mm:ss";
    private SimpleDateFormat sdf;
    @InitParam
    private String pattern;

    public Future() {
        this(DEFAULT_PATTERN);
    }

    public Future(String pattern) {
        this.pattern = pattern;
        this.sdf = new SimpleDateFormat(this.pattern);
    }

    @Override
    public boolean isValid(Object value) {
        if (ObjectUtils.isEmpty(value)) {
            return true;
        }
        try {
            Date date = this.sdf.parse(value.toString());
            return date.after(new Date());
        }
        catch (ParseException e) {
            return false;
        }
    }
}

