/*
 * Decompiled with CFR 0.152.
 */
package org.devefx.validator.constraints;

import org.devefx.validator.ConstraintValidator;
import org.devefx.validator.constraints.annotation.InitParam;
import org.devefx.validator.script.annotation.Script;

@Script
public class Length
implements ConstraintValidator {
    @InitParam
    private int min;
    @InitParam
    private int max;

    public Length(int min, int max) {
        this.min = min;
        this.max = max;
        this.validateParameters();
    }

    @Override
    public boolean isValid(Object value) {
        if (value == null) {
            return true;
        }
        String stringValue = value.toString();
        int length = stringValue.length();
        return length >= this.min && length <= this.max;
    }

    private void validateParameters() {
        if (this.min < 0) {
            throw new IllegalArgumentException("The min parameter cannot be negative.");
        }
        if (this.max < 0) {
            throw new IllegalArgumentException("The max parameter cannot be negative.");
        }
        if (this.max < this.min) {
            throw new IllegalArgumentException("The length cannot be negative.");
        }
    }
}

