/*
 * Decompiled with CFR 0.152.
 */
package org.devefx.validator.constraints;

import java.math.BigDecimal;
import java.math.BigInteger;
import org.devefx.validator.ConstraintValidator;
import org.devefx.validator.constraints.annotation.InitParam;
import org.devefx.validator.script.annotation.Script;
import org.devefx.validator.util.ObjectUtils;

@Script
public class Min
implements ConstraintValidator {
    @InitParam
    private long minValue;

    public Min(long minValue) {
        this.minValue = minValue;
    }

    @Override
    public boolean isValid(Object value) {
        Number numValue;
        if (ObjectUtils.isEmpty(value)) {
            return true;
        }
        if (value instanceof Number) {
            numValue = (Number)value;
        } else if (value instanceof String) {
            numValue = new BigDecimal((String)value);
        } else {
            throw new IllegalArgumentException("Unsupported of type [" + value.getClass().getName() + "]");
        }
        if (numValue instanceof Double) {
            if ((Double)numValue == Double.POSITIVE_INFINITY) {
                return true;
            }
            if (Double.isNaN((Double)numValue) || (Double)numValue == Double.NEGATIVE_INFINITY) {
                return false;
            }
        } else if (numValue instanceof Float) {
            if (((Float)numValue).floatValue() == Float.POSITIVE_INFINITY) {
                return true;
            }
            if (Float.isNaN(((Float)numValue).floatValue()) || ((Float)numValue).floatValue() == Float.NEGATIVE_INFINITY) {
                return false;
            }
        }
        if (numValue instanceof BigDecimal) {
            return ((BigDecimal)numValue).compareTo(BigDecimal.valueOf(this.minValue)) != -1;
        }
        if (numValue instanceof BigInteger) {
            return ((BigInteger)numValue).compareTo(BigInteger.valueOf(this.minValue)) != -1;
        }
        long longValue = numValue.longValue();
        return longValue >= this.minValue;
    }
}

