/*
 * Decompiled with CFR 0.152.
 */
package org.devefx.validator.constraints;

import org.devefx.validator.ConstraintValidator;
import org.devefx.validator.constraints.annotation.InitParam;
import org.devefx.validator.script.annotation.Script;
import org.devefx.validator.util.Assert;

@Script
public class Options
implements ConstraintValidator {
    @InitParam
    private ConstraintValidator[] subValidators;

    public Options(ConstraintValidator firstValidator, ConstraintValidator secondValidator, ConstraintValidator ... subValidators) {
        Assert.notNull(firstValidator, "firstValidator cannot be null.");
        Assert.notNull(secondValidator, "secondValidator cannot be null.");
        this.subValidators = new ConstraintValidator[2 + subValidators.length];
        this.subValidators[0] = firstValidator;
        this.subValidators[1] = secondValidator;
        if (subValidators.length != 0) {
            System.arraycopy(subValidators, 0, this.subValidators, 2, subValidators.length);
        }
    }

    @Override
    public boolean isValid(Object value) {
        ConstraintValidator[] constraintValidatorArray = this.subValidators;
        int n = this.subValidators.length;
        int n2 = 0;
        while (n2 < n) {
            ConstraintValidator validator = constraintValidatorArray[n2];
            if (validator != null && validator.isValid(value)) {
                return true;
            }
            ++n2;
        }
        return false;
    }
}

