/*
 * Decompiled with CFR 0.152.
 */
package org.devefx.validator.constraints;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.devefx.validator.ConstraintValidator;
import org.devefx.validator.constraints.annotation.InitParam;
import org.devefx.validator.script.annotation.Script;
import org.devefx.validator.util.ObjectUtils;

@Script
public class Regex
implements ConstraintValidator {
    private Pattern pattern;
    @InitParam
    private String regexp;
    @InitParam
    private int flags;

    public Regex(String regexp) {
        this(regexp, 0);
    }

    public Regex(String regexp, int flags) {
        try {
            this.regexp = regexp;
            this.flags = flags;
            this.pattern = Pattern.compile(this.regexp, this.flags);
        }
        catch (PatternSyntaxException e) {
            throw new IllegalArgumentException("Invalid regular expression.");
        }
    }

    @Override
    public boolean isValid(Object value) {
        if (ObjectUtils.isEmpty(value)) {
            return true;
        }
        Matcher m = this.pattern.matcher(value.toString());
        return m.matches();
    }
}

