/*
 * Decompiled with CFR 0.152.
 */
package org.devefx.validator.constraints;

import org.devefx.validator.ConstraintValidator;
import org.devefx.validator.constraints.annotation.InitParam;
import org.devefx.validator.script.annotation.Script;
import org.devefx.validator.util.Assert;
import org.devefx.validator.util.ObjectUtils;
import org.devefx.validator.util.StringUtils;

@Script
public class Separator
implements ConstraintValidator {
    @InitParam
    private ConstraintValidator validator;
    @InitParam
    private String separator;
    @InitParam
    private boolean ignoreLastBlank;

    public Separator(ConstraintValidator validator, String separator) {
        this(validator, separator, true);
    }

    public Separator(ConstraintValidator validator, String separator, boolean ignoreLastBlank) {
        Assert.notNull(validator, "validator cannot be null.");
        Assert.hasLength(separator, "separator cannot be empty.");
        this.validator = validator;
        this.separator = separator;
        this.ignoreLastBlank = ignoreLastBlank;
    }

    @Override
    public boolean isValid(Object value) {
        String[] subTexts;
        int pos;
        String lastString;
        if (ObjectUtils.isEmpty(value)) {
            return true;
        }
        String stringValue = value.toString();
        if (this.ignoreLastBlank && !StringUtils.hasText(lastString = stringValue.substring((pos = stringValue.lastIndexOf(this.separator)) + 1))) {
            stringValue = stringValue.substring(0, pos);
        }
        String[] stringArray = subTexts = stringValue.split(this.separator);
        int n = subTexts.length;
        int n2 = 0;
        while (n2 < n) {
            String subText = stringArray[n2];
            if (!this.validator.isValid(subText)) {
                return false;
            }
            ++n2;
        }
        return true;
    }
}

