/*
 * Decompiled with CFR 0.152.
 */
package org.devefx.validator.constraints;

import java.lang.reflect.Array;
import java.util.Collection;
import org.devefx.validator.ConstraintValidator;
import org.devefx.validator.constraints.annotation.InitParam;
import org.devefx.validator.script.annotation.Script;

@Script
public class Size
implements ConstraintValidator {
    @InitParam
    private int min;
    @InitParam
    private int max;

    public Size(int min, int max) {
        this.min = min;
        this.max = max;
        this.validateParameters();
    }

    @Override
    public boolean isValid(Object value) {
        if (value == null) {
            return true;
        }
        try {
            int length = 1;
            if (value instanceof Collection) {
                length = ((Collection)value).size();
            } else if (value instanceof Object[]) {
                length = Array.getLength(value);
            }
            return length >= this.min && length <= this.max;
        }
        catch (IllegalArgumentException e) {
            return false;
        }
    }

    private void validateParameters() {
        if (this.min < 0) {
            throw new IllegalArgumentException("The min parameter cannot be negative.");
        }
        if (this.max < 0) {
            throw new IllegalArgumentException("The max parameter cannot be negative.");
        }
        if (this.max < this.min) {
            throw new IllegalArgumentException("The length cannot be negative.");
        }
    }
}

