/*
 * Decompiled with CFR 0.152.
 */
package org.devefx.validator.constraints;

import java.net.MalformedURLException;
import org.devefx.validator.ConstraintValidator;
import org.devefx.validator.constraints.annotation.InitParam;
import org.devefx.validator.script.annotation.Script;

@Script
public class URL
implements ConstraintValidator {
    @InitParam
    private String protocol;
    @InitParam
    private String host;
    @InitParam
    private int port;

    public URL() {
        this(null, null, -1);
    }

    public URL(String protocol, String host, int port) {
        this.protocol = protocol;
        this.host = host;
        this.port = port;
    }

    @Override
    public boolean isValid(Object value) {
        java.net.URL url;
        if (value == null) {
            return true;
        }
        String stringValue = value.toString();
        if (stringValue.length() == 0) {
            return true;
        }
        try {
            url = new java.net.URL(stringValue);
        }
        catch (MalformedURLException e) {
            return false;
        }
        if (this.protocol != null && this.protocol.length() > 0 && !url.getProtocol().equals(this.protocol)) {
            return false;
        }
        if (this.host != null && this.host.length() > 0 && !url.getHost().equals(this.host)) {
            return false;
        }
        return this.port == -1 || url.getPort() == this.port;
    }
}

