/*
 * Decompiled with CFR 0.152.
 */
package org.devefx.validator.constraints.multipart;

import org.devefx.validator.ConstraintValidator;
import org.devefx.validator.constraints.annotation.InitParam;
import org.devefx.validator.script.annotation.Script;
import org.devefx.validator.web.multipart.ImageMultipartFile;

@Script
public class ImageRatio
implements ConstraintValidator {
    @InitParam
    private float ratio;

    public ImageRatio(float ratio) {
        this.ratio = ratio;
    }

    @Override
    public boolean isValid(Object value) {
        if (value == null) {
            return true;
        }
        if (!(value instanceof ImageMultipartFile)) {
            throw new IllegalArgumentException("Unsupported of type [" + value.getClass().getName() + "]");
        }
        ImageMultipartFile image = (ImageMultipartFile)value;
        float width = image.getWidth();
        float height = image.getHeight();
        return this.ratio == width / height;
    }
}

