/*
 * Decompiled with CFR 0.152.
 */
package org.devefx.validator.constraints.multipart;

import org.devefx.validator.ConstraintValidator;
import org.devefx.validator.constraints.annotation.InitParam;
import org.devefx.validator.script.annotation.Script;
import org.devefx.validator.web.multipart.ImageMultipartFile;

@Script
public class ImageSize
implements ConstraintValidator {
    @InitParam
    private int minWidth;
    @InitParam
    private int maxWidth;
    @InitParam
    private int minHeight;
    @InitParam
    private int maxHeight;

    public ImageSize(int maxWidth, int maxHeight) {
        this(1, maxWidth, 1, maxHeight);
    }

    public ImageSize(int minWidth, int maxWidth, int minHeight, int maxHeight) {
        this.minWidth = minWidth;
        this.maxWidth = maxWidth;
        this.minHeight = minHeight;
        this.maxHeight = maxHeight;
        this.validateParameters();
    }

    @Override
    public boolean isValid(Object value) {
        if (value == null) {
            return true;
        }
        if (!(value instanceof ImageMultipartFile)) {
            throw new IllegalArgumentException("Unsupported of type [" + value.getClass().getName() + "]");
        }
        ImageMultipartFile image = (ImageMultipartFile)value;
        int width = image.getWidth();
        int height = image.getHeight();
        return width >= this.minWidth && width <= this.maxWidth && height >= this.minHeight && height <= this.maxHeight;
    }

    private void validateParameters() {
        if (this.minWidth < 1) {
            throw new IllegalArgumentException("The minWidth parameter cannot be less than 1.");
        }
        if (this.maxWidth < 1) {
            throw new IllegalArgumentException("The maxWidth parameter cannot be less than 1.");
        }
        if (this.minHeight < 1) {
            throw new IllegalArgumentException("The minHeight parameter cannot be less than 1.");
        }
        if (this.maxHeight < 1) {
            throw new IllegalArgumentException("The maxHeight parameter cannot be less than 1.");
        }
        if (this.maxWidth < this.minWidth) {
            throw new IllegalArgumentException("The width cannot be negative.");
        }
        if (this.maxHeight < this.minHeight) {
            throw new IllegalArgumentException("The height cannot be negative.");
        }
    }
}

