/*
 * Decompiled with CFR 0.152.
 */
package org.devefx.validator.constraints.multipart;

import org.devefx.validator.ConstraintValidator;
import org.devefx.validator.constraints.annotation.InitParam;
import org.devefx.validator.script.annotation.Script;
import org.devefx.validator.web.multipart.MultipartFile;

@Script
public class MultipartSize
implements ConstraintValidator {
    @InitParam
    private int min;
    @InitParam
    private int max;

    public MultipartSize(int max) {
        this(1, max);
    }

    public MultipartSize(int min, int max) {
        this.min = min;
        this.max = max;
        this.validateParameters();
    }

    @Override
    public boolean isValid(Object value) {
        if (value == null) {
            return true;
        }
        if (!(value instanceof MultipartFile)) {
            throw new IllegalArgumentException("Unsupported of type [" + value.getClass().getName() + "]");
        }
        MultipartFile file = (MultipartFile)value;
        long size = file.getSize();
        return size >= (long)this.min && size <= (long)this.max;
    }

    private void validateParameters() {
        if (this.min < 1) {
            throw new IllegalArgumentException("The min parameter cannot be less than 1.");
        }
        if (this.max < 1) {
            throw new IllegalArgumentException("The max parameter cannot be less than 1.");
        }
        if (this.max < this.min) {
            throw new IllegalArgumentException("The length cannot be negative.");
        }
    }
}

