/*
 * Decompiled with CFR 0.152.
 */
package org.devefx.validator.external.beanvalidation;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import javax.validation.Validator;
import javax.validation.ValidatorFactory;
import org.devefx.validator.ConstraintViolation;
import org.devefx.validator.Validation;
import org.devefx.validator.ValidationContext;
import org.devefx.validator.ValidatorDelegate;
import org.devefx.validator.ValueContext;
import org.devefx.validator.internal.engine.ConstraintViolationImpl;
import org.hibernate.validator.HibernateValidator;
import org.hibernate.validator.HibernateValidatorConfiguration;

public class HibernateValidation
implements Validation,
ValidatorDelegate {
    protected Validator validator;

    @Override
    public void initialize(ValidationContext context) {
        context.setValidatorDelegate(this);
        HibernateValidatorConfiguration configure = (HibernateValidatorConfiguration)javax.validation.Validation.byProvider(HibernateValidator.class).configure();
        if (context instanceof ValidationContext.Accessor) {
            configure.failFast(((ValidationContext.Accessor)context).isFailFast());
        }
        ValidatorFactory factory = configure.buildValidatorFactory();
        this.validator = factory.getValidator();
    }

    @Override
    public List<ConstraintViolation> validate(ValueContext valueContext, ValidationContext.Accessor context, Class<?> ... groups) {
        Set violations = this.validator.validate(valueContext.getCurrentBean(), (Class[])groups);
        if (violations.size() > 0) {
            ArrayList<ConstraintViolation> constraintViolations = new ArrayList<ConstraintViolation>(violations.size());
            for (javax.validation.ConstraintViolation violation : violations) {
                ConstraintViolationImpl constraintViolation = ConstraintViolationImpl.forParameterValidation(violation.getPropertyPath().toString(), violation.getMessageTemplate(), violation.getMessage(), Collections.emptyMap(), violation.getRootBeanClass(), violation.getRootBean(), violation.getInvalidValue(), null);
                constraintViolations.add(constraintViolation);
            }
            return constraintViolations;
        }
        return Collections.emptyList();
    }
}

