/*
 * Decompiled with CFR 0.152.
 */
package org.devefx.validator.external.spring;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.devefx.validator.Validation;
import org.devefx.validator.internal.engine.DefaultValidationFactory;
import org.springframework.beans.BeansException;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;

public class SpringValidationFactory
extends DefaultValidationFactory
implements ApplicationContextAware {
    private final Log logger = LogFactory.getLog(SpringValidationFactory.class);
    private ApplicationContext applicationContext;

    @Override
    public Validation getValidation(Class<? extends Validation> validationClass) throws Exception {
        try {
            return (Validation)this.applicationContext.getBean(validationClass);
        }
        catch (BeansException e) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("No qualifying bean of type [" + validationClass.getName() + "] is defined"));
            }
            return super.getValidation(validationClass);
        }
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = applicationContext;
    }
}

