/*
 * Decompiled with CFR 0.152.
 */
package org.devefx.validator.external.spring.mvc;

import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.devefx.validator.Validator;
import org.devefx.validator.ValidatorUtils;
import org.devefx.validator.internal.util.FakeServletConfig;
import org.devefx.validator.internal.util.WebContextThreadStack;
import org.springframework.web.context.ServletContextAware;
import org.springframework.web.method.HandlerMethod;
import org.springframework.web.servlet.handler.HandlerInterceptorAdapter;

public class SpringValidatorInterceptor
extends HandlerInterceptorAdapter
implements ServletContextAware {
    private ServletConfig servletConfig;

    public void setServletContext(ServletContext servletContext) {
        this.servletConfig = new FakeServletConfig("springInterceptor", servletContext);
    }

    public boolean preHandle(HttpServletRequest request, HttpServletResponse response, Object handler) throws Exception {
        Validator validator = ValidatorUtils.getValidator();
        if (handler instanceof HandlerMethod) {
            try {
                WebContextThreadStack.engageThread(this.servletConfig, request, response);
                HandlerMethod handlerMethod = (HandlerMethod)handler;
                if (!validator.validate(handlerMethod.getBeanType(), request, response)) {
                    return false;
                }
                if (!validator.validate(handlerMethod.getMethod(), request, response)) {
                    return false;
                }
            }
            finally {
                WebContextThreadStack.disengageThread();
            }
        }
        return super.preHandle(request, response, handler);
    }
}

