/*
 * Decompiled with CFR 0.152.
 */
package org.devefx.validator.external.struts2;

import com.opensymphony.xwork2.ActionContext;
import com.opensymphony.xwork2.ActionInvocation;
import com.opensymphony.xwork2.ActionProxy;
import com.opensymphony.xwork2.ActionSupport;
import com.opensymphony.xwork2.interceptor.MethodFilterInterceptor;
import java.lang.reflect.Method;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.struts2.util.ServletContextAware;
import org.devefx.validator.Validator;
import org.devefx.validator.ValidatorUtils;
import org.devefx.validator.internal.util.FakeServletConfig;
import org.devefx.validator.internal.util.WebContextThreadStack;

public class Struts2ValidatorInterceptor
extends MethodFilterInterceptor
implements ServletContextAware {
    private static final long serialVersionUID = -7579546773406364670L;
    private ServletConfig servletConfig;

    public void setServletContext(ServletContext servletContext) {
        this.servletConfig = new FakeServletConfig("struts2Interceptor", servletContext);
    }

    protected String doIntercept(ActionInvocation invocation) throws Exception {
        ActionProxy actionProxy = invocation.getProxy();
        if (actionProxy instanceof ActionSupport) {
            HttpServletResponse response;
            HttpServletRequest request;
            try {
                ActionContext context = invocation.getInvocationContext();
                request = (HttpServletRequest)context.get("com.opensymphony.xwork2.dispatcher.HttpServletRequest");
                response = (HttpServletResponse)context.get("com.opensymphony.xwork2.dispatcher.HttpServletResponse");
            }
            catch (ClassCastException e) {
                throw new ServletException("non-HTTP request or response");
            }
            try {
                WebContextThreadStack.engageThread(this.servletConfig, request, response);
                Class<?> actionClass = actionProxy.getAction().getClass();
                Validator validator = ValidatorUtils.getValidator();
                if (!validator.validate(actionClass, request, response)) {
                    return null;
                }
                Method actionMethod = actionClass.getDeclaredMethod(actionProxy.getMethod(), new Class[0]);
                if (!validator.validate(actionMethod, request, response)) {
                    return null;
                }
            }
            finally {
                WebContextThreadStack.disengageThread();
            }
        }
        return invocation.invoke();
    }
}

