/*
 * Decompiled with CFR 0.152.
 */
package org.devefx.validator.http.extract;

import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.devefx.validator.http.HttpServletRequestWrapper;
import org.devefx.validator.http.MediaType;
import org.devefx.validator.http.extract.RequestExtractor;
import org.devefx.validator.http.reader.HttpMessageReader;
import org.devefx.validator.util.ClassUtils;
import org.devefx.validator.util.MultiValueMap;
import org.devefx.validator.util.ServletUtils;

public class HttpMessageReaderExtractor
implements RequestExtractor {
    private static final Log logger = LogFactory.getLog(HttpMessageReaderExtractor.class);
    private final List<HttpMessageReader<?>> messageReaders;
    private final Map<Class<?>, Object> instances = new HashMap(4);

    public HttpMessageReaderExtractor(List<HttpMessageReader<?>> messageReaders) {
        this.messageReaders = messageReaders;
    }

    @Override
    public <T> T extractData(Class<T> requiredClass, HttpServletRequest request) throws IOException {
        HttpServletRequestWrapper requestWrapper = new HttpServletRequestWrapper(request);
        if (!requestWrapper.hasMessageBody() || requestWrapper.hasEmptyMessageBody()) {
            if (requiredClass.isAssignableFrom(MultiValueMap.class)) {
                return (T)ServletUtils.extractUrlParams((HttpServletRequest)requestWrapper);
            }
            return this.getInstance(requiredClass);
        }
        MediaType contentType = this.getContentType((HttpServletRequest)requestWrapper);
        for (HttpMessageReader<T> httpMessageReader : this.messageReaders) {
            if (requiredClass == null || !httpMessageReader.canRead(requiredClass, contentType)) continue;
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Reading [" + requiredClass.getName() + "] as \"" + contentType + "\" using [" + httpMessageReader + "]"));
            }
            return (T)httpMessageReader.read(requiredClass, (HttpServletRequest)requestWrapper);
        }
        throw new RuntimeException("Could not extract request: no suitable HttpMessageReader found for request type [" + requiredClass + "] and content type [" + contentType + "]");
    }

    private MediaType getContentType(HttpServletRequest request) {
        String contentType = request.getContentType();
        if (contentType == null) {
            if (logger.isTraceEnabled()) {
                logger.trace((Object)"No Content-Type header found, defaulting to application/octet-stream");
            }
            return MediaType.APPLICATION_OCTET_STREAM;
        }
        return MediaType.parseMediaType(contentType);
    }

    private <T> T getInstance(Class<T> clazz) {
        Object instance = this.instances.get(clazz);
        if (instance == null) {
            try {
                instance = ClassUtils.newInstance(clazz);
                this.instances.put(clazz, instance);
            }
            catch (Exception e) {
                throw new IllegalArgumentException(String.valueOf(clazz.getName()) + " cannot be instantiated");
            }
        }
        return (T)instance;
    }
}

