/*
 * Decompiled with CFR 0.152.
 */
package org.devefx.validator.http.reader;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.devefx.validator.http.MediaType;
import org.devefx.validator.http.reader.HttpMessageNotReadableException;
import org.devefx.validator.http.reader.HttpMessageReader;
import org.devefx.validator.util.Assert;

public abstract class AbstractHttpMessageReader<T>
implements HttpMessageReader<T> {
    protected final Log logger = LogFactory.getLog(this.getClass());
    private List<MediaType> supportedMediaTypes = Collections.emptyList();

    public AbstractHttpMessageReader() {
    }

    protected AbstractHttpMessageReader(MediaType supportedMediaType) {
        this.setSupportedMediaTypes(Collections.singletonList(supportedMediaType));
    }

    protected AbstractHttpMessageReader(MediaType ... supportedMediaTypes) {
        this.setSupportedMediaTypes(Arrays.asList(supportedMediaTypes));
    }

    public void setSupportedMediaTypes(List<MediaType> supportedMediaTypes) {
        Assert.notEmpty(supportedMediaTypes, "'supportedMediaTypes' must not be empty");
        this.supportedMediaTypes = new ArrayList<MediaType>(supportedMediaTypes);
    }

    @Override
    public List<MediaType> getSupportedMediaTypes() {
        return Collections.unmodifiableList(this.supportedMediaTypes);
    }

    @Override
    public boolean canRead(Class<?> clazz, MediaType mediaType) {
        return this.supports(clazz) && this.canRead(mediaType);
    }

    protected boolean canRead(MediaType mediaType) {
        if (mediaType == null) {
            return true;
        }
        for (MediaType supportedMediaType : this.getSupportedMediaTypes()) {
            if (!supportedMediaType.includes(mediaType)) continue;
            return true;
        }
        return false;
    }

    @Override
    public T read(Class<? extends T> clazz, HttpServletRequest request) throws IOException, HttpMessageNotReadableException {
        return this.readInternal(clazz, request);
    }

    protected abstract boolean supports(Class<?> var1);

    protected abstract T readInternal(Class<? extends T> var1, HttpServletRequest var2) throws IOException, HttpMessageNotReadableException;
}

