/*
 * Decompiled with CFR 0.152.
 */
package org.devefx.validator.http.reader;

import java.io.IOException;
import java.io.InputStream;
import java.net.URLDecoder;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import org.devefx.validator.http.MediaType;
import org.devefx.validator.http.reader.HttpMessageNotReadableException;
import org.devefx.validator.http.reader.HttpMessageReader;
import org.devefx.validator.util.LinkedMultiValueMap;
import org.devefx.validator.util.MultiValueMap;
import org.devefx.validator.util.ServletUtils;
import org.devefx.validator.util.StreamUtils;
import org.devefx.validator.util.StringUtils;

public class FormHttpMessageReader
implements HttpMessageReader<MultiValueMap<String, ?>> {
    protected Charset charset = Charset.forName("UTF-8");
    protected List<MediaType> supportedMediaTypes = new ArrayList<MediaType>();

    public FormHttpMessageReader() {
        this.supportedMediaTypes.add(MediaType.APPLICATION_FORM_URLENCODED);
    }

    public void setCharset(Charset charset) {
        this.charset = charset;
    }

    @Override
    public boolean canRead(Class<?> clazz, MediaType mediaType) {
        if (!MultiValueMap.class.isAssignableFrom(clazz)) {
            return false;
        }
        if (mediaType == null) {
            return true;
        }
        for (MediaType supportedMediaType : this.getSupportedMediaTypes()) {
            if (!supportedMediaType.includes(mediaType)) continue;
            return true;
        }
        return false;
    }

    public void setSupportedMediaTypes(List<MediaType> supportedMediaTypes) {
        this.supportedMediaTypes = supportedMediaTypes;
    }

    @Override
    public List<MediaType> getSupportedMediaTypes() {
        return Collections.unmodifiableList(this.supportedMediaTypes);
    }

    @Override
    public MultiValueMap<String, ?> read(Class<? extends MultiValueMap<String, ?>> clazz, HttpServletRequest request) throws IOException, HttpMessageNotReadableException {
        MediaType contentType = MediaType.parseMediaType(request.getContentType());
        Charset charset = contentType.getCharSet() != null ? contentType.getCharSet() : this.charset;
        String body = StreamUtils.copyToString((InputStream)request.getInputStream(), charset);
        String[] pairs = StringUtils.tokenizeToStringArray(body, "&");
        LinkedMultiValueMap<String, String> result = new LinkedMultiValueMap<String, String>(pairs.length);
        ServletUtils.extractUrlParams(result, request);
        String[] stringArray = pairs;
        int n = pairs.length;
        int n2 = 0;
        while (n2 < n) {
            String pair = stringArray[n2];
            int idx = pair.indexOf(61);
            if (idx == -1) {
                result.add(URLDecoder.decode(pair, charset.name()), null);
            } else {
                String name = URLDecoder.decode(pair.substring(0, idx), charset.name());
                String value = URLDecoder.decode(pair.substring(idx + 1), charset.name());
                result.add(name, value);
            }
            ++n2;
        }
        return result;
    }
}

