/*
 * Decompiled with CFR 0.152.
 */
package org.devefx.validator.http.reader.json;

import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Type;
import java.nio.charset.Charset;
import java.util.concurrent.atomic.AtomicReference;
import javax.servlet.ServletInputStream;
import javax.servlet.http.HttpServletRequest;
import org.devefx.validator.http.MediaType;
import org.devefx.validator.http.reader.AbstractHttpMessageReader;
import org.devefx.validator.http.reader.HttpMessageNotReadableException;
import org.devefx.validator.util.Assert;

public abstract class AbstractJackson2HttpMessageReader
extends AbstractHttpMessageReader<Object> {
    public static final Charset DEFAULT_CHARSET = Charset.forName("UTF-8");
    protected ObjectMapper objectMapper;
    private Boolean prettyPrint;

    protected AbstractJackson2HttpMessageReader(ObjectMapper objectMapper) {
        this.objectMapper = objectMapper;
    }

    protected AbstractJackson2HttpMessageReader(ObjectMapper objectMapper, MediaType supportedMediaType) {
        super(supportedMediaType);
        this.objectMapper = objectMapper;
    }

    protected AbstractJackson2HttpMessageReader(ObjectMapper objectMapper, MediaType ... supportedMediaTypes) {
        super(supportedMediaTypes);
        this.objectMapper = objectMapper;
    }

    public void setObjectMapper(ObjectMapper objectMapper) {
        Assert.notNull(objectMapper, "ObjectMapper must not be null");
        this.objectMapper = objectMapper;
        this.configurePrettyPrint();
    }

    public ObjectMapper getObjectMapper() {
        return this.objectMapper;
    }

    public void setPrettyPrint(boolean prettyPrint) {
        this.prettyPrint = prettyPrint;
        this.configurePrettyPrint();
    }

    private void configurePrettyPrint() {
        if (this.prettyPrint != null) {
            this.objectMapper.configure(SerializationFeature.INDENT_OUTPUT, this.prettyPrint.booleanValue());
        }
    }

    @Override
    protected boolean supports(Class<?> clazz) {
        AtomicReference causeRef;
        JavaType javaType = this.getJavaType(clazz);
        if (this.objectMapper.canDeserialize(javaType, causeRef = new AtomicReference())) {
            return true;
        }
        Throwable cause = (Throwable)causeRef.get();
        if (cause != null) {
            String msg = "Failed to evaluate deserialization for type " + javaType;
            if (this.logger.isDebugEnabled()) {
                this.logger.warn((Object)msg, cause);
            } else {
                this.logger.warn((Object)(String.valueOf(msg) + ": " + cause));
            }
        }
        return false;
    }

    @Override
    protected Object readInternal(Class<? extends Object> clazz, HttpServletRequest request) throws IOException, HttpMessageNotReadableException {
        JavaType javaType = this.getJavaType(clazz);
        return this.readJavaType(javaType, request);
    }

    private Object readJavaType(JavaType javaType, HttpServletRequest request) {
        try {
            ServletInputStream in = request.getInputStream();
            return this.objectMapper.readValue((InputStream)in, javaType);
        }
        catch (IOException ex) {
            throw new HttpMessageNotReadableException("Could not read JSON: " + ex.getMessage(), ex);
        }
    }

    protected JavaType getJavaType(Type type) {
        return this.objectMapper.getTypeFactory().constructType(type);
    }
}

