/*
 * Decompiled with CFR 0.152.
 */
package org.devefx.validator.http.reader.multipart;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.fileupload.FileItem;
import org.apache.commons.fileupload.FileItemFactory;
import org.apache.commons.fileupload.FileUploadException;
import org.apache.commons.fileupload.disk.DiskFileItemFactory;
import org.apache.commons.fileupload.servlet.ServletFileUpload;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.devefx.validator.http.MediaType;
import org.devefx.validator.http.reader.FormHttpMessageReader;
import org.devefx.validator.http.reader.HttpMessageNotReadableException;
import org.devefx.validator.http.reader.multipart.CommonsImageMultipartFile;
import org.devefx.validator.http.reader.multipart.CommonsMultipartFile;
import org.devefx.validator.util.MultiValueMap;
import org.devefx.validator.util.ServletUtils;

public class MultipartFormHttpMessageReader
extends FormHttpMessageReader {
    private static final Log logger = LogFactory.getLog(MultipartFormHttpMessageReader.class);
    private static List<MediaType> imageMediaTypes = new ArrayList<MediaType>(3);

    static {
        imageMediaTypes.add(MediaType.IMAGE_GIF);
        imageMediaTypes.add(MediaType.IMAGE_JPEG);
        imageMediaTypes.add(MediaType.IMAGE_PNG);
    }

    public MultipartFormHttpMessageReader() {
        this.supportedMediaTypes.add(MediaType.MULTIPART_FORM_DATA);
    }

    @Override
    public MultiValueMap<String, ?> read(Class<? extends MultiValueMap<String, ?>> clazz, HttpServletRequest request) throws IOException, HttpMessageNotReadableException {
        MultiValueMap result = ServletUtils.extractUrlParams(request);
        if (ServletFileUpload.isMultipartContent((HttpServletRequest)request)) {
            DiskFileItemFactory factory = new DiskFileItemFactory();
            ServletFileUpload fileUpload = new ServletFileUpload((FileItemFactory)factory);
            try {
                List fileItems = fileUpload.parseRequest(request);
                for (FileItem fileItem : fileItems) {
                    if (fileItem.isFormField()) {
                        result.add(fileItem.getFieldName(), fileItem.getString(this.charset.name()));
                        continue;
                    }
                    if (this.isImageMediaType(fileItem.getContentType())) {
                        result.add(fileItem.getFieldName(), new CommonsImageMultipartFile(fileItem));
                        continue;
                    }
                    result.add(fileItem.getFieldName(), new CommonsMultipartFile(fileItem));
                }
            }
            catch (FileUploadException e) {
                logger.error((Object)"File upload failed", (Throwable)e);
            }
        }
        return result;
    }

    private boolean isImageMediaType(String contentType) {
        if (contentType == null) {
            return false;
        }
        MediaType type = MediaType.parseMediaType(contentType);
        for (MediaType mediaType : imageMediaTypes) {
            if (!mediaType.includes(type)) continue;
            return true;
        }
        return false;
    }
}

