/*
 * Decompiled with CFR 0.152.
 */
package org.devefx.validator.internal.engine;

import java.util.HashMap;
import java.util.List;
import org.devefx.validator.ConstraintViolation;
import org.devefx.validator.InvalidHandler;
import org.devefx.validator.internal.util.ResultResponse;
import org.devefx.validator.web.View;
import org.devefx.validator.web.view.AbstractNestedView;
import org.devefx.validator.web.view.json.NestedJsonView;
import org.devefx.validator.web.view.xml.NestedXmlView;

public class DefaultInvalidHandler
implements InvalidHandler {
    private OutputStyle outputStyle = OutputStyle.JSON;

    public void setOutputStyle(OutputStyle outputStyle) {
        this.outputStyle = outputStyle;
    }

    @Override
    public View renderInvalid(List<ConstraintViolation> violations) {
        if (violations == null || violations.isEmpty()) {
            return null;
        }
        AbstractNestedView view = null;
        if (this.outputStyle == OutputStyle.JSON) {
            view = new NestedJsonView();
        } else if (this.outputStyle == OutputStyle.XML) {
            view = new NestedXmlView();
        }
        HashMap<String, String> errorMap = new HashMap<String, String>(violations.size());
        for (ConstraintViolation violation : violations) {
            String name = violation.getName();
            if (errorMap.containsKey(name)) continue;
            errorMap.put(violation.getName(), violation.getMessage());
        }
        ResultResponse response = new ResultResponse(101, errorMap);
        view.addStaticAttribute("response", response);
        view.setExtractValueFromSingleKeyModel(true);
        return view;
    }

    public static enum OutputStyle {
        JSON,
        XML;

    }
}

