/*
 * Decompiled with CFR 0.152.
 */
package org.devefx.validator.internal.engine;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.devefx.validator.ConstraintDescriptor;
import org.devefx.validator.ConstraintValidator;
import org.devefx.validator.ConstraintViolation;
import org.devefx.validator.ValidationContext;
import org.devefx.validator.ValidatorContext;
import org.devefx.validator.ValidatorDelegate;
import org.devefx.validator.ValueContext;
import org.devefx.validator.groups.Default;
import org.devefx.validator.internal.engine.groups.Group;
import org.devefx.validator.internal.engine.groups.ValidationOrder;
import org.devefx.validator.internal.engine.groups.ValidationOrderGenerator;
import org.devefx.validator.internal.util.BeanReader;
import org.devefx.validator.util.Assert;

public class DefaultValidatorDelegate
implements ValidatorDelegate {
    private static final Collection<Class<?>> DEFAULT_GROUPS = Collections.singletonList(Default.class);
    private final transient ValidationOrderGenerator validationOrderGenerator = new ValidationOrderGenerator();

    @Override
    public List<ConstraintViolation> validate(ValueContext valueContext, ValidationContext.Accessor context, Class<?> ... groups) {
        ArrayList<ConstraintViolation> failingConstraintViolations = new ArrayList<ConstraintViolation>();
        ValidationOrder validationOrder = this.determineGroupValidationOrder(groups);
        Iterator<Group> groupIterator = validationOrder.getGroupIterator();
        while (groupIterator.hasNext()) {
            Group group = groupIterator.next();
            valueContext.setCurrentGroup(group.getDefiningClass());
            this.validateConstraintsForCurrentGroup(context, valueContext, failingConstraintViolations);
            if (!this.shouldFailFast(context, failingConstraintViolations)) continue;
            return failingConstraintViolations;
        }
        return failingConstraintViolations;
    }

    protected void validateConstraintsForCurrentGroup(ValidationContext.Accessor context, ValueContext valueContext, List<ConstraintViolation> failingConstraintViolations) {
        BeanReader beanReader = null;
        if (valueContext.getCurrentBean() != null) {
            beanReader = new BeanReader(valueContext.getCurrentBean());
        }
        for (ConstraintDescriptor descriptor : context.getConstraintDescriptors()) {
            if (this.isValidationRequired(valueContext, descriptor)) {
                ConstraintViolation constraintViolation;
                if (beanReader != null) {
                    Object valueToValidate = beanReader.getProperty(descriptor.getName());
                    valueContext.setCurrentValidatedValue(valueToValidate);
                }
                if ((constraintViolation = this.validateConstraint(context, valueContext, descriptor)) != null) {
                    failingConstraintViolations.add(constraintViolation);
                }
            }
            if (!this.shouldFailFast(context, failingConstraintViolations)) continue;
            return;
        }
    }

    protected ConstraintViolation validateConstraint(ValidationContext.Accessor context, ValueContext valueContext, ConstraintDescriptor descriptor) {
        boolean isValid;
        block3: {
            isValid = false;
            try {
                ConstraintValidator validator = descriptor.getConstraintValidator();
                isValid = validator.isValid(valueContext.getCurrentValidatedValue());
            }
            catch (RuntimeException e) {
                if (!context.isThrowException()) break block3;
                throw new RuntimeException("Unexpected exception during isValid call.", e);
            }
        }
        if (!isValid) {
            ValidatorContext validatorContext = context.getValidatorContext();
            return validatorContext.createConstraintViolation(context, valueContext, descriptor);
        }
        return null;
    }

    protected boolean isValidationRequired(ValueContext valueContext, ConstraintDescriptor descriptor) {
        return descriptor.getGroups().contains(valueContext.getCurrentGroup());
    }

    protected boolean shouldFailFast(ValidationContext.Accessor context, List<ConstraintViolation> failingConstraintViolations) {
        return context.isFailFast() && !failingConstraintViolations.isEmpty();
    }

    protected ValidationOrder determineGroupValidationOrder(Class<?>[] groups) {
        Assert.notNull(groups, "null passed as group name.");
        Class<?>[] classArray = groups;
        int n = groups.length;
        int n2 = 0;
        while (n2 < n) {
            Class<?> clazz = classArray[n2];
            if (clazz == null) {
                throw new IllegalArgumentException("null passed as group name.");
            }
            ++n2;
        }
        Collection<Class<?>> resultGroups = groups.length == 0 ? DEFAULT_GROUPS : Arrays.asList(groups);
        return this.validationOrderGenerator.getValidationOrder(resultGroups);
    }
}

