/*
 * Decompiled with CFR 0.152.
 */
package org.devefx.validator.internal.engine;

import java.lang.reflect.AnnotatedElement;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import org.devefx.validator.GroupMatchException;
import org.devefx.validator.Valid;
import org.devefx.validator.Validation;
import org.devefx.validator.internal.util.BeanReader;
import org.devefx.validator.util.ObjectUtils;

public class ValidElement {
    public static final ValidElement NULL_VALID = new ValidElement(null);
    public static final Class<?>[] EMPTY_GROUPS = new Class[0];
    private Valid annotation;

    public static ValidElement by(AnnotatedElement annotatedElement) {
        Valid annotation = annotatedElement.getAnnotation(Valid.class);
        if (annotation == null) {
            return NULL_VALID;
        }
        return new ValidElement(annotation);
    }

    public ValidElement(Valid annotation) {
        this.annotation = annotation;
    }

    public Class<?>[] getGroups(Object bean) throws GroupMatchException {
        if (bean == null) {
            return this.getGroups();
        }
        Object[] annotatedGroups = this.annotation.groupsFormRequest();
        if (ObjectUtils.isEmpty(annotatedGroups)) {
            return this.getGroups();
        }
        BeanReader beanReader = new BeanReader(bean);
        Set<Class<?>> groups = this.newGroups();
        Object[] objectArray = annotatedGroups;
        int n = annotatedGroups.length;
        int n2 = 0;
        while (n2 < n) {
            Object annotatedGroup = objectArray[n2];
            Class<?> group = null;
            Object value = beanReader.getProperty(annotatedGroup.name());
            if (value != null) {
                Valid.Group.GroupMapping[] groupMappingArray = annotatedGroup.mappings();
                int n3 = groupMappingArray.length;
                int n4 = 0;
                while (n4 < n3) {
                    Valid.Group.GroupMapping mapping = groupMappingArray[n4];
                    if (mapping.name().equals(value)) {
                        group = mapping.group();
                        break;
                    }
                    ++n4;
                }
            }
            if (group == null) {
                if (annotatedGroup.required()) {
                    throw new GroupMatchException(String.valueOf(value), "[" + annotatedGroup.name() + "]");
                }
                group = annotatedGroup.defaultGroup();
            }
            groups.add(group);
            ++n2;
        }
        return groups.toArray(EMPTY_GROUPS);
    }

    protected Set<Class<?>> newGroups() {
        HashSet groups = new HashSet();
        if (!ObjectUtils.isEmpty(this.getGroups())) {
            groups.addAll(Arrays.asList(this.getGroups()));
        }
        return groups;
    }

    public Class<?>[] getGroups() {
        return this.annotation.groups();
    }

    public Class<? extends Validation> getValidationClass() {
        return this.annotation.value();
    }

    public Class<?> getRequestType() {
        return this.annotation.requestType();
    }

    public boolean preventDefault() {
        return this.annotation.preventDefault();
    }

    public boolean isConstrained() {
        return this.annotation != null;
    }
}

