/*
 * Decompiled with CFR 0.152.
 */
package org.devefx.validator.internal.engine;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import org.devefx.validator.ConstraintDescriptor;
import org.devefx.validator.ConstraintValidator;
import org.devefx.validator.InvalidHandler;
import org.devefx.validator.Validation;
import org.devefx.validator.ValidationContext;
import org.devefx.validator.ValidatorContext;
import org.devefx.validator.ValidatorDelegate;
import org.devefx.validator.internal.engine.ConstraintDescriptorImpl;
import org.devefx.validator.internal.resourceloading.ResourceBundleLocator;
import org.devefx.validator.util.Assert;

public class ValidationContextAccessor
implements ValidationContext.Accessor {
    private static final String MESSAGE_SUFFIX = ".message";
    private boolean failFast;
    private boolean throwException;
    private ResourceBundleLocator resourceBundleLocator;
    private ValidatorDelegate validatorDelegate;
    private InvalidHandler invalidHandler;
    private final List<ConstraintDescriptor> constraintDescriptors;
    private final Validation validation;
    private final ValidatorContext validatorContext;

    public ValidationContextAccessor(Validation validation, ValidatorContext validatorContext) {
        this.validation = validation;
        this.validatorContext = validatorContext;
        this.constraintDescriptors = new ArrayList<ConstraintDescriptor>();
    }

    @Override
    public void setFailFast(boolean failFast) {
        this.failFast = failFast;
    }

    @Override
    public void setThrowException(boolean throwException) {
        this.throwException = throwException;
    }

    @Override
    public void setResourceBundleLocator(ResourceBundleLocator resourceBundleLocator) {
        this.resourceBundleLocator = resourceBundleLocator;
    }

    @Override
    public void setValidatorDelegate(ValidatorDelegate delegate) {
        this.validatorDelegate = delegate;
    }

    @Override
    public void setInvalidHandler(InvalidHandler invalidHandler) {
        this.invalidHandler = invalidHandler;
    }

    @Override
    public boolean isFailFast() {
        return this.failFast;
    }

    @Override
    public boolean isThrowException() {
        return this.throwException;
    }

    @Override
    public ResourceBundleLocator getResourceBundleLocator() {
        return this.resourceBundleLocator;
    }

    @Override
    public ValidatorDelegate getValidatorDelegate() {
        return this.validatorDelegate;
    }

    @Override
    public InvalidHandler getInvalidHandler() {
        return this.invalidHandler;
    }

    @Override
    public List<ConstraintDescriptor> getConstraintDescriptors() {
        return this.constraintDescriptors;
    }

    @Override
    public Validation getValidation() {
        return this.validation;
    }

    @Override
    public ValidatorContext getValidatorContext() {
        return this.validatorContext;
    }

    @Override
    public void constraint(String name, String message, ConstraintValidator constraintValidator, Class<?> ... groups) {
        Assert.notNull(name, "name cannot be null.");
        Assert.notNull(constraintValidator, "constraintValidator cannot be null.");
        HashSet resultGroups = groups.length == 0 ? DEFAULT_GROUPS : new HashSet(Arrays.asList(groups));
        ConstraintDescriptorImpl constraintDescriptor = new ConstraintDescriptorImpl(name, message, resultGroups, constraintValidator);
        this.constraintDescriptors.add(constraintDescriptor);
    }

    @Override
    public void constraint(String name, ConstraintValidator constraintValidator, Class<?> ... groups) {
        Assert.notNull(name, "name cannot be null.");
        Assert.notNull(constraintValidator, "constraintValidator cannot be null.");
        String messageTemplate = ValidationContextAccessor.getDefaultMessagetTemplate(constraintValidator);
        this.constraint(name, messageTemplate, constraintValidator, groups);
    }

    private static String getDefaultMessagetTemplate(ConstraintValidator constraintValidator) {
        Class<?> constraintClass = constraintValidator.getClass();
        String className = constraintClass.getName();
        StringBuilder sb = new StringBuilder().append('{');
        sb.append(className).append(MESSAGE_SUFFIX).append('}');
        return sb.toString();
    }
}

