/*
 * Decompiled with CFR 0.152.
 */
package org.devefx.validator.internal.engine;

import java.util.ArrayList;
import java.util.List;
import org.devefx.validator.ValidationFactory;
import org.devefx.validator.Validator;
import org.devefx.validator.ValidatorConfig;
import org.devefx.validator.ValidatorFactory;
import org.devefx.validator.http.reader.FormHttpMessageReader;
import org.devefx.validator.http.reader.HttpMessageReader;
import org.devefx.validator.http.reader.json.FastJsonHttpMessageReader;
import org.devefx.validator.http.reader.json.MappingJackson2HttpMessageReader;
import org.devefx.validator.http.reader.multipart.MultipartFormHttpMessageReader;
import org.devefx.validator.http.reader.xml.MappingJackson2XmlHttpMessageReader;
import org.devefx.validator.internal.engine.DefaultInvalidHandler;
import org.devefx.validator.internal.engine.DefaultValidationFactory;
import org.devefx.validator.internal.engine.DefaultValidatorDelegate;
import org.devefx.validator.internal.engine.ValidatorImpl;
import org.devefx.validator.messageinterpolation.MessageInterpolator;
import org.devefx.validator.messageinterpolation.ResourceBundleMessageInterpolator;
import org.devefx.validator.util.Assert;
import org.devefx.validator.util.ClassUtils;

public class ValidatorFactoryImpl
implements ValidatorFactory {
    private static final boolean jackson2Present = ClassUtils.isPresent("com.fasterxml.jackson.databind.ObjectMapper", ValidatorFactoryImpl.class.getClassLoader()) && ClassUtils.isPresent("com.fasterxml.jackson.core.JsonGenerator", ValidatorFactoryImpl.class.getClassLoader());
    private static final boolean jackson2XmlPresent = ClassUtils.isPresent("com.fasterxml.jackson.dataformat.xml.XmlMapper", ValidatorFactoryImpl.class.getClassLoader());
    private static final boolean fastjsonPresent = ClassUtils.isPresent("com.alibaba.fastjson.JSON", ValidatorFactoryImpl.class.getClassLoader());
    private static final boolean commonsFileUploadPresent = ClassUtils.isPresent("org.apache.commons.fileupload.servlet.ServletFileUpload", ValidatorFactoryImpl.class.getClassLoader());
    private MessageInterpolator messageInterpolator;
    private List<HttpMessageReader<?>> messageReaders;
    private ValidationFactory validationFactory;
    private ValidatorConfig validatorConfig;
    private boolean initialized;

    public ValidatorFactoryImpl() {
    }

    public ValidatorFactoryImpl(ValidatorConfig validatorConfig) {
        this.setValidatorConfig(validatorConfig);
    }

    @Override
    public MessageInterpolator getMessageInterpolator() {
        return this.messageInterpolator;
    }

    @Override
    public List<HttpMessageReader<?>> getMessageReaders() {
        return this.messageReaders;
    }

    @Override
    public ValidationFactory getValidationFactory() {
        return this.validationFactory;
    }

    @Override
    public ValidatorConfig getValidatorConfig() {
        return this.validatorConfig;
    }

    public void setMessageInterpolator(MessageInterpolator messageInterpolator) {
        this.messageInterpolator = messageInterpolator;
    }

    public void setMessageReaders(List<HttpMessageReader<?>> messageReaders) {
        this.messageReaders = messageReaders;
    }

    public void setValidationFactory(ValidationFactory validationFactory) {
        this.validationFactory = validationFactory;
    }

    public void setValidatorConfig(ValidatorConfig validatorConfig) {
        Assert.notNull(validatorConfig, "validator config must not be null.");
        this.validatorConfig = validatorConfig;
    }

    public void init() {
        if (this.initialized) {
            return;
        }
        this.initialized = true;
        if (this.validatorConfig == null) {
            throw new IllegalArgumentException("validator config must not be null.");
        }
        if (this.messageInterpolator == null) {
            this.messageInterpolator = new ResourceBundleMessageInterpolator();
        }
        if (this.messageReaders == null) {
            this.messageReaders = new ArrayList();
            this.messageReaders.add(new FormHttpMessageReader());
            if (commonsFileUploadPresent) {
                this.messageReaders.add(new MultipartFormHttpMessageReader());
            }
            if (jackson2Present) {
                this.messageReaders.add(new MappingJackson2HttpMessageReader());
            } else if (fastjsonPresent) {
                this.messageReaders.add(new FastJsonHttpMessageReader());
            }
            if (jackson2XmlPresent) {
                this.messageReaders.add(new MappingJackson2XmlHttpMessageReader());
            }
        }
        if (this.validationFactory == null) {
            this.validationFactory = new DefaultValidationFactory();
        }
        if (this.validatorConfig.getInvalidHandler() == null) {
            this.validatorConfig.setInvalidHandler(new DefaultInvalidHandler());
        }
        if (this.validatorConfig.getValidatorDelegate() == null) {
            this.validatorConfig.setValidatorDelegate(new DefaultValidatorDelegate());
        }
    }

    @Override
    public Validator buildValidator() {
        this.init();
        return new ValidatorImpl(this);
    }
}

