/*
 * Decompiled with CFR 0.152.
 */
package org.devefx.validator.internal.engine.groups;

import java.util.Arrays;
import java.util.Collection;
import org.devefx.validator.ValidationException;
import org.devefx.validator.groups.Default;
import org.devefx.validator.internal.engine.groups.DefaultValidationOrder;
import org.devefx.validator.internal.engine.groups.Group;
import org.devefx.validator.internal.engine.groups.ValidationOrder;

public class ValidationOrderGenerator {
    private final DefaultValidationOrder validationOrderForDefaultGroup = new DefaultValidationOrder();

    public ValidationOrderGenerator() {
        this.validationOrderForDefaultGroup.insertGroup(Group.DEFAULT_GROUP);
    }

    public ValidationOrder getValidationOrder(Class<?> group, boolean expand) {
        if (expand) {
            return this.getValidationOrder(Arrays.asList(group));
        }
        DefaultValidationOrder validationOrder = new DefaultValidationOrder();
        validationOrder.insertGroup(new Group(group));
        return validationOrder;
    }

    public ValidationOrder getValidationOrder(Collection<Class<?>> groups) {
        if (groups == null || groups.size() == 0) {
            throw new IllegalArgumentException("At least one group has to be specified.");
        }
        if (groups.size() == 1 && groups.contains(Default.class)) {
            return this.validationOrderForDefaultGroup;
        }
        for (Class<?> clazz : groups) {
            if (clazz.isInterface()) continue;
            throw new ValidationException("A group has to be an interface. " + clazz + " is not.");
        }
        DefaultValidationOrder validationOrder = new DefaultValidationOrder();
        for (Class<?> clazz : groups) {
            if (Default.class.equals(clazz)) {
                validationOrder.insertGroup(Group.DEFAULT_GROUP);
                continue;
            }
            Group group = new Group(clazz);
            validationOrder.insertGroup(group);
            this.insertInheritedGroups(clazz, validationOrder);
        }
        return validationOrder;
    }

    private void insertInheritedGroups(Class<?> clazz, DefaultValidationOrder chain) {
        Class<?>[] classArray = clazz.getInterfaces();
        int n = classArray.length;
        int n2 = 0;
        while (n2 < n) {
            Class<?> inheritedGroup = classArray[n2];
            Group group = new Group(inheritedGroup);
            chain.insertGroup(group);
            this.insertInheritedGroups(inheritedGroup, chain);
            ++n2;
        }
    }
}

