/*
 * Decompiled with CFR 0.152.
 */
package org.devefx.validator.internal.engine.scanner;

import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.net.JarURLConnection;
import java.net.URL;
import java.util.Enumeration;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.devefx.validator.internal.engine.scanner.TypeFilter;
import org.devefx.validator.util.Assert;
import org.devefx.validator.util.ClassUtils;

public class ClassPathScanner {
    private static final Log logger = LogFactory.getLog(ClassPathScanner.class);
    private static final String CLASS_SUFFIX = ".class";
    private final List<TypeFilter> includeFilters = new LinkedList<TypeFilter>();
    private final List<TypeFilter> excludeFilters = new LinkedList<TypeFilter>();
    private ClassLoader classLoader;

    public void setClassLoader(ClassLoader classLoader) {
        this.classLoader = classLoader;
    }

    public void addIncludeFilter(TypeFilter includeFilter) {
        this.includeFilters.add(includeFilter);
    }

    public void addExcludeFilter(TypeFilter excludeFilter) {
        this.excludeFilters.add(0, excludeFilter);
    }

    public void resetFilters() {
        this.includeFilters.clear();
        this.excludeFilters.clear();
    }

    public Set<Class<?>> scan(String ... basePackages) {
        Assert.notEmpty(basePackages, "At least one base package must be specified");
        LinkedHashSet classes = new LinkedHashSet();
        String[] stringArray = basePackages;
        int n = basePackages.length;
        int n2 = 0;
        while (n2 < n) {
            String basePackage = stringArray[n2];
            Set<Class<?>> candidates = this.findCandidateClasses(basePackage);
            for (Class<?> candidate : candidates) {
                if (!this.isCandidate(candidate)) continue;
                classes.add(candidate);
            }
            ++n2;
        }
        return classes;
    }

    public Set<Class<?>> findCandidateClasses(String basePackage) {
        LinkedHashSet candidates = new LinkedHashSet();
        try {
            String packageSearchPath = basePackage.replace('.', '/');
            ClassLoader classLoader = this.classLoader;
            if (classLoader == null) {
                classLoader = Thread.currentThread().getContextClassLoader();
            }
            Enumeration<URL> resources = classLoader.getResources(packageSearchPath);
            while (resources.hasMoreElements()) {
                URL resource = resources.nextElement();
                if (logger.isTraceEnabled()) {
                    logger.trace((Object)("Scanning " + resource));
                }
                if ("file".equals(resource.getProtocol())) {
                    this.findClasses(candidates, classLoader, basePackage, resource.getFile());
                    continue;
                }
                if (!"jar".equals(resource.getProtocol())) continue;
                this.findClasses(candidates, classLoader, packageSearchPath, (JarURLConnection)resource.openConnection());
            }
        }
        catch (IOException e) {
            throw new RuntimeException("I/O failure during classpath scanning", e);
        }
        return candidates;
    }

    protected void findClasses(Set<Class<?>> classes, ClassLoader classLoader, String packageName, String packagePath) {
        File dir = new File(packagePath);
        if (!dir.exists() || !dir.isDirectory()) {
            return;
        }
        File[] fileArray = dir.listFiles(new DefaultFileFilter());
        int n = fileArray.length;
        int n2 = 0;
        while (n2 < n) {
            File file = fileArray[n2];
            if (file.isDirectory()) {
                this.findClasses(classes, classLoader, String.valueOf(packageName) + "." + file.getName(), file.getPath());
            } else {
                String className = String.valueOf(packageName.concat(".")) + file.getName().replace(CLASS_SUFFIX, "");
                try {
                    Class<?> c = ClassUtils.forName(className, classLoader);
                    classes.add(c);
                }
                catch (ClassNotFoundException classNotFoundException) {
                    // empty catch block
                }
            }
            ++n2;
        }
    }

    protected void findClasses(Set<Class<?>> classes, ClassLoader classLoader, String packageName, JarURLConnection connection) throws IOException {
        JarFile jarFile = connection.getJarFile();
        if (jarFile == null) {
            return;
        }
        Enumeration<JarEntry> entries = jarFile.entries();
        while (entries.hasMoreElements()) {
            JarEntry entry = entries.nextElement();
            String name = entry.getName();
            if (!name.endsWith(CLASS_SUFFIX) || !name.startsWith(packageName)) continue;
            String className = name.replace('/', '.').replace(CLASS_SUFFIX, "");
            try {
                Class<?> c = ClassUtils.forName(className, classLoader);
                classes.add(c);
            }
            catch (ClassNotFoundException e) {
                e.printStackTrace();
            }
        }
    }

    protected boolean isCandidate(Class<?> candidate) throws IllegalStateException {
        for (TypeFilter filter : this.excludeFilters) {
            if (!filter.match(candidate)) continue;
            return false;
        }
        for (TypeFilter filter : this.includeFilters) {
            if (!filter.match(candidate)) continue;
            return true;
        }
        return false;
    }

    class DefaultFileFilter
    implements FileFilter {
        DefaultFileFilter() {
        }

        @Override
        public boolean accept(File file) {
            return file.isDirectory() || file.isFile() && file.getName().endsWith(ClassPathScanner.CLASS_SUFFIX);
        }
    }
}

