/*
 * Decompiled with CFR 0.152.
 */
package org.devefx.validator.internal.metadata;

import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.devefx.validator.ConstraintValidator;
import org.devefx.validator.constraints.annotation.InitParam;
import org.devefx.validator.internal.metadata.ConstraintMetaData;
import org.devefx.validator.script.annotation.Script;
import org.devefx.validator.util.StringUtils;

public class ConstraintMetaDataImpl
implements ConstraintMetaData {
    private static final Log logger = LogFactory.getLog(ConstraintMetaDataImpl.class);
    private final Class<?> constraintClass;
    private final List<Field> initParamAnnotationFields = new ArrayList<Field>();
    private boolean hasScriptAnnotation;
    private String scriptId;
    private boolean scriptRemote;

    public ConstraintMetaDataImpl(Class<?> constraintClass) {
        this.constraintClass = constraintClass;
        this.presentInitParamAnnotationFields();
        this.parserScriptAnnotation();
    }

    private void presentInitParamAnnotationFields() {
        Field[] fieldArray = this.constraintClass.getDeclaredFields();
        int n = fieldArray.length;
        int n2 = 0;
        while (n2 < n) {
            Field field = fieldArray[n2];
            if (field.isAnnotationPresent(InitParam.class)) {
                this.initParamAnnotationFields.add(field);
            }
            ++n2;
        }
    }

    private void parserScriptAnnotation() {
        Script script = this.constraintClass.getAnnotation(Script.class);
        if (script != null) {
            this.hasScriptAnnotation = true;
            this.scriptId = script.id();
            this.scriptRemote = script.remote();
            if (!StringUtils.hasText(this.scriptId)) {
                this.scriptId = this.constraintClass.getSimpleName();
            }
        }
    }

    @Override
    public Class<?> getType() {
        return this.constraintClass;
    }

    @Override
    public Map<String, Object> getInitParams(ConstraintValidator constraintValidator) {
        if (this.initParamAnnotationFields.isEmpty()) {
            return Collections.emptyMap();
        }
        LinkedHashMap<String, Object> initParams = new LinkedHashMap<String, Object>(this.initParamAnnotationFields.size());
        for (Field field : this.initParamAnnotationFields) {
            if (!field.isAccessible()) {
                field.setAccessible(true);
            }
            try {
                initParams.put(field.getName(), field.get(constraintValidator));
            }
            catch (IllegalAccessException e) {
                if (!logger.isInfoEnabled()) continue;
                logger.info((Object)e.getMessage(), (Throwable)e);
            }
        }
        return initParams;
    }

    @Override
    public boolean hasScriptAnnotation() {
        return this.hasScriptAnnotation;
    }

    @Override
    public String getScriptID() {
        return this.scriptId;
    }

    @Override
    public boolean isScriptRemote() {
        return this.scriptRemote;
    }
}

