/*
 * Decompiled with CFR 0.152.
 */
package org.devefx.validator.internal.metadata;

import java.util.EnumSet;
import org.devefx.validator.internal.metadata.ConstraintMetaData;
import org.devefx.validator.internal.metadata.ConstraintMetaDataImpl;
import org.devefx.validator.internal.util.ConcurrentReferenceHashMap;

public class ConstraintMetaDataManager {
    private static final int DEFAULT_INITIAL_CAPACITY = 16;
    private static final float DEFAULT_LOAD_FACTOR = 0.75f;
    private static final int DEFAULT_CONCURRENCY_LEVEL = 16;
    private final ConcurrentReferenceHashMap<Class<?>, ConstraintMetaData> constraintMetaDataCache = new ConcurrentReferenceHashMap(16, 0.75f, 16, ConcurrentReferenceHashMap.ReferenceType.SOFT, ConcurrentReferenceHashMap.ReferenceType.SOFT, EnumSet.of(ConcurrentReferenceHashMap.Option.IDENTITY_COMPARISONS));

    public ConstraintMetaData getConstraintMetaData(Class<?> constraintClass) {
        return this.getOrCreateConstraintMetaData(constraintClass);
    }

    public void clear() {
        this.constraintMetaDataCache.clear();
    }

    public int numberOfCachedConstraintMetaDataInstances() {
        return this.constraintMetaDataCache.size();
    }

    private ConstraintMetaData createConstraintMetaData(Class<?> constraintClass) {
        return new ConstraintMetaDataImpl(constraintClass);
    }

    private ConstraintMetaData getOrCreateConstraintMetaData(Class<?> constraintClass) {
        ConstraintMetaData cachedConstraintMetaData;
        ConstraintMetaData constraintMetaData = this.constraintMetaDataCache.get(constraintClass);
        if (constraintMetaData == null && (cachedConstraintMetaData = this.constraintMetaDataCache.putIfAbsent(constraintClass, constraintMetaData = this.createConstraintMetaData(constraintClass))) != null) {
            constraintMetaData = cachedConstraintMetaData;
        }
        return constraintMetaData;
    }
}

