/*
 * Decompiled with CFR 0.152.
 */
package org.devefx.validator.internal.resourceloading;

import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.devefx.validator.internal.resourceloading.ResourceBundleLocator;

public class PlatformResourceBundleLocator
implements ResourceBundleLocator {
    private static final Log log = LogFactory.getLog((String)PlatformResourceBundleLocator.class.getName());
    private final String bundleName;

    public PlatformResourceBundleLocator(String bundleName) {
        this.bundleName = bundleName;
    }

    @Override
    public ResourceBundle getResourceBundle(Locale locale) {
        ResourceBundle rb = null;
        ClassLoader classLoader = GetClassLoader.fromContext();
        if (classLoader != null) {
            rb = this.loadBundle(classLoader, locale, String.valueOf(this.bundleName) + " not found by thread local classloader");
        }
        if (rb == null) {
            classLoader = GetClassLoader.fromClass(PlatformResourceBundleLocator.class);
            rb = this.loadBundle(classLoader, locale, String.valueOf(this.bundleName) + " not found by validator classloader");
        }
        if (rb != null) {
            log.debug((Object)(String.valueOf(this.bundleName) + " found."));
        } else {
            log.debug((Object)(String.valueOf(this.bundleName) + " not found."));
        }
        return rb;
    }

    private ResourceBundle loadBundle(ClassLoader classLoader, Locale locale, String message) {
        ResourceBundle rb = null;
        try {
            rb = ResourceBundle.getBundle(this.bundleName, locale, classLoader);
        }
        catch (MissingResourceException e) {
            log.trace((Object)message);
        }
        return rb;
    }

    private static class GetClassLoader
    implements PrivilegedAction<ClassLoader> {
        private final Class<?> clazz;

        private static ClassLoader fromContext() {
            GetClassLoader action = new GetClassLoader(null);
            if (System.getSecurityManager() != null) {
                return AccessController.doPrivileged(action);
            }
            return action.run();
        }

        private static ClassLoader fromClass(Class<?> clazz) {
            if (clazz == null) {
                throw new IllegalArgumentException("Class is null");
            }
            GetClassLoader action = new GetClassLoader(clazz);
            if (System.getSecurityManager() != null) {
                return AccessController.doPrivileged(action);
            }
            return action.run();
        }

        private GetClassLoader(Class<?> clazz) {
            this.clazz = clazz;
        }

        @Override
        public ClassLoader run() {
            if (this.clazz != null) {
                return this.clazz.getClassLoader();
            }
            return Thread.currentThread().getContextClassLoader();
        }
    }
}

