/*
 * Decompiled with CFR 0.152.
 */
package org.devefx.validator.internal.util;

import java.util.List;
import java.util.Map;
import org.apache.commons.beanutils.PropertyUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.devefx.validator.util.Assert;
import org.devefx.validator.util.MultiValueMap;

public class BeanReader {
    private static final Log log = LogFactory.getLog(BeanReader.class);
    private final Object bean;

    public BeanReader(Object bean) {
        Assert.notNull(bean, "bean must not be null.");
        this.bean = bean;
    }

    public Object getProperty(String name) {
        if (this.bean instanceof Map) {
            if (this.bean instanceof MultiValueMap) {
                MultiValueMap valueMap = (MultiValueMap)this.bean;
                List values = (List)valueMap.get(name);
                if (values == null || values.isEmpty()) {
                    return null;
                }
                if (values.size() == 1) {
                    return values.get(0);
                }
                return values;
            }
            return ((Map)this.bean).get(name);
        }
        try {
            return PropertyUtils.getProperty((Object)this.bean, (String)name);
        }
        catch (Exception e) {
            if (log.isWarnEnabled()) {
                log.warn((Object)("Property '" + name + "' does not exist for object of " + "type " + this.bean.getClass().getName() + "."));
            }
            return null;
        }
    }

    public void setProperty(String name, Object value) {
        block4: {
            if (this.bean instanceof Map) {
                if (this.bean instanceof MultiValueMap) {
                    MultiValueMap valueMap = (MultiValueMap)this.bean;
                    valueMap.set(name, value);
                    return;
                }
                Map map = (Map)this.bean;
                map.put(name, value);
                return;
            }
            try {
                PropertyUtils.setProperty((Object)this.bean, (String)name, (Object)value);
            }
            catch (Exception e) {
                if (!log.isWarnEnabled()) break block4;
                log.warn((Object)("Property '" + name + "' can't setter for object of " + "type " + this.bean.getClass().getName() + "."));
            }
        }
    }
}

