/*
 * Decompiled with CFR 0.152.
 */
package org.devefx.validator.internal.util;

import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;

public class FakeServletConfig
implements ServletConfig {
    private final String name;
    private final ServletContext servletContext;
    private final Map<String, String> initParameters;

    public FakeServletConfig(String name, ServletContext servletContext) {
        this(name, servletContext, null);
    }

    public FakeServletConfig(String name, ServletContext servletContext, Map<String, String> initParameters) {
        this.name = name;
        this.servletContext = servletContext;
        this.initParameters = initParameters != null ? Collections.unmodifiableMap(initParameters) : Collections.emptyMap();
    }

    public FakeServletConfig(ServletConfig servletConfig) {
        this.name = servletConfig.getServletName();
        this.servletContext = servletConfig.getServletContext();
        this.initParameters = this.getInitParametersInServletConfig(servletConfig);
    }

    public String getServletName() {
        return this.name;
    }

    public ServletContext getServletContext() {
        return this.servletContext;
    }

    public String getInitParameter(String name) {
        return this.initParameters.get(name);
    }

    public Enumeration<String> getInitParameterNames() {
        return Collections.enumeration(this.initParameters.keySet());
    }

    private Map<String, String> getInitParametersInServletConfig(ServletConfig servletConfig) {
        HashMap<String, String> initParameters = new HashMap<String, String>();
        Enumeration params = servletConfig.getInitParameterNames();
        while (params.hasMoreElements()) {
            String name = (String)params.nextElement();
            String value = servletConfig.getInitParameter(name);
            initParameters.put(name, value);
        }
        return Collections.unmodifiableMap(initParameters);
    }
}

