/*
 * Decompiled with CFR 0.152.
 */
package org.devefx.validator.internal.util;

import java.io.IOException;
import java.io.InputStream;
import java.util.Enumeration;
import java.util.Properties;
import java.util.Set;
import javax.servlet.ServletConfig;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.devefx.validator.beans.Container;
import org.devefx.validator.beans.DefaultContainer;
import org.devefx.validator.internal.engine.scanner.ClassPathScanner;
import org.devefx.validator.internal.engine.scanner.filter.ValidationScriptMappingTypeFilter;
import org.devefx.validator.util.ClassUtils;
import org.devefx.validator.util.ResourceUtils;
import org.devefx.validator.util.StringUtils;

public class StartupUtil {
    private static final Log log = LogFactory.getLog(StartupUtil.class);
    public static final String SYSTEM_DEFAULT_PROPERTIES_PATH = "org/devefx/validator/defaults.properties";
    public static final String PROP_PREFIX = "p:";
    public static final String CHOOSE_TOKEN = ",";
    public static final String SCAN_PACKAGE_INIT_PARAMETER = "scan-package";
    public static final String GENERATED_BEAN_NAME_SEPARATOR = "#";

    public static void setupDefaultContainer(DefaultContainer container, ServletConfig servletConfig) {
        Properties defaults = new Properties();
        try {
            InputStream in = ResourceUtils.getResourceAsStream(SYSTEM_DEFAULT_PROPERTIES_PATH);
            defaults.load(in);
            Enumeration en = servletConfig.getInitParameterNames();
            while (en.hasMoreElements()) {
                String name = (String)en.nextElement();
                String value = servletConfig.getInitParameter(name);
                defaults.setProperty(name, value);
            }
            for (String name : defaults.stringPropertyNames()) {
                String value = defaults.getProperty(name);
                if (name.startsWith(PROP_PREFIX)) {
                    name = name.substring(PROP_PREFIX.length());
                    container.setProperty(name, value);
                    continue;
                }
                StartupUtil.createNewInstance(container, name, value);
            }
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to load system defaults", e);
        }
        container.setupFinished();
    }

    private static void createNewInstance(DefaultContainer container, String askFor, String value) {
        if (container.containsBean(askFor)) {
            log.info((Object)("An instance with name '" + askFor + "' already exists.  " + "Redefining this object as a new instance of type: " + value));
        }
        Class<?> requiredClass = null;
        try {
            requiredClass = ClassUtils.forName(askFor);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (requiredClass != null && !container.getBeansOfType(requiredClass).isEmpty()) {
            log.info((Object)("An instance with type '" + askFor + "' already exists.  " + "Redefining this object as a new instance of type: " + value));
        }
        String[] stringArray = value.split(CHOOSE_TOKEN);
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            block9: {
                String className = stringArray[n2];
                if ((className = StringUtils.clean(className)) != null) {
                    try {
                        Object instance = ClassUtils.newInstance(className);
                        if (requiredClass == null || requiredClass.isInstance(instance)) {
                            container.addBean(askFor, instance);
                            return;
                        }
                    }
                    catch (Throwable e) {
                        if (!log.isDebugEnabled()) break block9;
                        log.debug((Object)("Unable to instantiate class [" + className + "] for object named '" + askFor + "'.  "), e);
                    }
                }
            }
            ++n2;
        }
    }

    public static Container createAndSetupDefaultContainer(ServletConfig servletConfig) {
        Container container;
        try {
            String typeName = servletConfig.getInitParameter(Container.class.getName());
            if (typeName == null) {
                container = new DefaultContainer();
            } else {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Using alternate Container implementation: " + typeName));
                }
                container = (Container)ClassUtils.newInstance(typeName);
            }
            if (container instanceof DefaultContainer) {
                Container defaultContainer = container;
                StartupUtil.scanValidationComponents(defaultContainer, servletConfig);
                StartupUtil.setupDefaultContainer(defaultContainer, servletConfig);
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return container;
    }

    private static void scanValidationComponents(DefaultContainer container, ServletConfig servletConfig) {
        String scanPackage = servletConfig.getInitParameter(SCAN_PACKAGE_INIT_PARAMETER);
        if (scanPackage == null) {
            return;
        }
        ClassPathScanner scanner = new ClassPathScanner();
        scanner.addIncludeFilter(new ValidationScriptMappingTypeFilter());
        Set<Class<?>> classes = scanner.scan(scanPackage);
        for (Class<?> beanClass : classes) {
            try {
                Object bean = ClassUtils.newInstance(beanClass);
                String beanName = StartupUtil.generateBeanName(beanClass, container);
                container.addBean(beanName, bean);
            }
            catch (Exception e) {
                log.error((Object)("Unable to instantiate class [" + beanClass.getName() + "]."), (Throwable)e);
            }
        }
    }

    public static String generateBeanName(Class<?> beanClass, Container container) {
        String generatedBeanName;
        String id = generatedBeanName = beanClass.getName();
        int counter = -1;
        while (counter == -1 || container.containsBean(id)) {
            id = String.valueOf(generatedBeanName) + GENERATED_BEAN_NAME_SEPARATOR + ++counter;
        }
        return id;
    }
}

