/*
 * Decompiled with CFR 0.152.
 */
package org.devefx.validator.internal.util;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.devefx.validator.Validator;

public abstract class ThreadContext {
    private static final Log log = LogFactory.getLog(ThreadContext.class);
    public static final String VALIDATOR_KEY = String.valueOf(ThreadContext.class.getName()) + "_VALIDATOR_KEY";
    public static final String MODEL_KEY = String.valueOf(ThreadContext.class.getName()) + "_MODEL_KEY";
    private static final ThreadLocal<Map<Object, Object>> resources = new InheritableThreadLocalMap();

    protected ThreadContext() {
    }

    public static Map<Object, Object> getResources() {
        if (resources.get() == null) {
            return Collections.emptyMap();
        }
        return new HashMap<Object, Object>(resources.get());
    }

    public static void setResources(Map<Object, Object> newResources) {
        if (newResources == null || newResources.isEmpty()) {
            return;
        }
        ThreadContext.ensureResourcesInitialized();
        resources.get().clear();
        resources.get().putAll(newResources);
    }

    private static Object getValue(Object key) {
        Map<Object, Object> perThreadResources = resources.get();
        return perThreadResources != null ? perThreadResources.get(key) : null;
    }

    private static void ensureResourcesInitialized() {
        if (resources.get() == null) {
            resources.set(new HashMap());
        }
    }

    public static Object get(Object key) {
        Object value;
        if (log.isTraceEnabled()) {
            String msg = "get() - in thread [" + Thread.currentThread().getName() + "]";
            log.trace((Object)msg);
        }
        if ((value = ThreadContext.getValue(key)) != null && log.isTraceEnabled()) {
            String msg = "Retrieved value of type [" + value.getClass().getName() + "] for key [" + key + "] " + "bound to thread [" + Thread.currentThread().getName() + "]";
            log.trace((Object)msg);
        }
        return value;
    }

    public static void put(Object key, Object value) {
        if (key == null) {
            throw new IllegalArgumentException("key cannot be null");
        }
        if (value == null) {
            ThreadContext.remove(key);
            return;
        }
        ThreadContext.ensureResourcesInitialized();
        resources.get().put(key, value);
        if (log.isTraceEnabled()) {
            String msg = "Bound value of type [" + value.getClass().getName() + "] for key [" + key + "] to thread " + "[" + Thread.currentThread().getName() + "]";
            log.trace((Object)msg);
        }
    }

    public static Object remove(Object key) {
        Object value;
        Map<Object, Object> perThreadResources = resources.get();
        Object object = value = perThreadResources != null ? perThreadResources.remove(key) : null;
        if (value != null && log.isTraceEnabled()) {
            String msg = "Removed value of type [" + value.getClass().getName() + "] for key [" + key + "]" + "from thread [" + Thread.currentThread().getName() + "]";
            log.trace((Object)msg);
        }
        return value;
    }

    public static void remove() {
        resources.remove();
    }

    public static Validator getValidator() {
        return (Validator)ThreadContext.get(VALIDATOR_KEY);
    }

    public static void bind(Validator validator) {
        if (validator != null) {
            ThreadContext.put(VALIDATOR_KEY, validator);
        }
    }

    public static Validator unbindValidator() {
        return (Validator)ThreadContext.remove(VALIDATOR_KEY);
    }

    public static Object getModel() {
        return ThreadContext.get(MODEL_KEY);
    }

    public static void bindModel(Object model) {
        if (model != null) {
            ThreadContext.put(MODEL_KEY, model);
        }
    }

    public static Object unbindModel() {
        return ThreadContext.remove(MODEL_KEY);
    }

    private static final class InheritableThreadLocalMap<T extends Map<Object, Object>>
    extends InheritableThreadLocal<Map<Object, Object>> {
        private InheritableThreadLocalMap() {
        }

        @Override
        protected Map<Object, Object> childValue(Map<Object, Object> parentValue) {
            if (parentValue != null) {
                return (Map)((HashMap)parentValue).clone();
            }
            return null;
        }
    }
}

