/*
 * Decompiled with CFR 0.152.
 */
package org.devefx.validator.internal.util;

import java.util.Stack;
import javax.servlet.ServletConfig;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.devefx.validator.WebContext;
import org.devefx.validator.web.context.DefaultWebContext;

public final class WebContextThreadStack {
    private static final Log log = LogFactory.getLog(WebContextThreadStack.class);
    private static ThreadLocal<Stack<WebContext>> contextStack = new ThreadLocal();

    private WebContextThreadStack() {
    }

    public static WebContext get() {
        Stack<WebContext> stack = contextStack.get();
        if (stack == null || stack.empty()) {
            return null;
        }
        return stack.peek();
    }

    public static void engageThread(ServletConfig servletConfig, HttpServletRequest request, HttpServletResponse response) {
        try {
            DefaultWebContext ec = new DefaultWebContext(request, response, servletConfig, servletConfig.getServletContext());
            WebContextThreadStack.engageThread(ec);
        }
        catch (Exception ex) {
            log.fatal((Object)"Failed to create an ExecutionContext", (Throwable)ex);
        }
    }

    public static void engageThread(WebContext webContext) {
        Stack<WebContext> stack = contextStack.get();
        if (stack == null) {
            stack = new Stack();
            contextStack.set(stack);
        }
        stack.add(webContext);
    }

    public static void disengageThread() {
        Stack<WebContext> stack;
        if (contextStack != null && (stack = contextStack.get()) != null) {
            if (!stack.empty()) {
                stack.pop();
            }
            if (stack.empty()) {
                contextStack.set(null);
            }
        }
    }
}

