/*
 * Decompiled with CFR 0.152.
 */
package org.devefx.validator.messageinterpolation;

import java.util.EnumSet;
import java.util.List;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.devefx.validator.ValidationException;
import org.devefx.validator.internal.engine.messageinterpolation.InterpolationTerm;
import org.devefx.validator.internal.engine.messageinterpolation.InterpolationTermType;
import org.devefx.validator.internal.engine.messageinterpolation.LocalizedMessage;
import org.devefx.validator.internal.engine.messageinterpolation.parser.MessageDescriptorFormatException;
import org.devefx.validator.internal.engine.messageinterpolation.parser.Token;
import org.devefx.validator.internal.engine.messageinterpolation.parser.TokenCollector;
import org.devefx.validator.internal.engine.messageinterpolation.parser.TokenIterator;
import org.devefx.validator.internal.resourceloading.PlatformResourceBundleLocator;
import org.devefx.validator.internal.resourceloading.ResourceBundleLocator;
import org.devefx.validator.internal.util.ConcurrentReferenceHashMap;
import org.devefx.validator.messageinterpolation.MessageInterpolator;

public class ResourceBundleMessageInterpolator
implements MessageInterpolator {
    private static final Log log = LogFactory.getLog(ResourceBundleMessageInterpolator.class);
    private static final int DEFAULT_INITIAL_CAPACITY = 100;
    private static final float DEFAULT_LOAD_FACTOR = 0.75f;
    private static final int DEFAULT_CONCURRENCY_LEVEL = 16;
    private static final String DEFAULT_VALIDATION_MESSAGES = "org.devefx.validator.ValidationMessages";
    public static final String USER_VALIDATION_MESSAGES = "ValidationMessages";
    private final Locale defaultLocale = Locale.getDefault();
    private final ResourceBundleLocator userResourceBundleLocator;
    private final ResourceBundleLocator defaultResourceBundleLocator;
    private final ConcurrentReferenceHashMap<LocalizedMessage, String> resolvedMessages;
    private final ConcurrentReferenceHashMap<String, List<Token>> tokenizedParameterMessages;
    private final ConcurrentReferenceHashMap<String, List<Token>> tokenizedELMessages;
    private final boolean cachingEnabled;

    public ResourceBundleMessageInterpolator() {
        this(null);
    }

    public ResourceBundleMessageInterpolator(ResourceBundleLocator userResourceBundleLocator) {
        this(userResourceBundleLocator, true);
    }

    public ResourceBundleMessageInterpolator(ResourceBundleLocator userResourceBundleLocator, boolean cacheMessages) {
        this.userResourceBundleLocator = userResourceBundleLocator == null ? new PlatformResourceBundleLocator(USER_VALIDATION_MESSAGES) : userResourceBundleLocator;
        this.defaultResourceBundleLocator = new PlatformResourceBundleLocator(DEFAULT_VALIDATION_MESSAGES);
        this.cachingEnabled = cacheMessages;
        if (this.cachingEnabled) {
            this.resolvedMessages = new ConcurrentReferenceHashMap(100, 0.75f, 16, ConcurrentReferenceHashMap.ReferenceType.SOFT, ConcurrentReferenceHashMap.ReferenceType.SOFT, EnumSet.noneOf(ConcurrentReferenceHashMap.Option.class));
            this.tokenizedParameterMessages = new ConcurrentReferenceHashMap(100, 0.75f, 16, ConcurrentReferenceHashMap.ReferenceType.SOFT, ConcurrentReferenceHashMap.ReferenceType.SOFT, EnumSet.noneOf(ConcurrentReferenceHashMap.Option.class));
            this.tokenizedELMessages = new ConcurrentReferenceHashMap(100, 0.75f, 16, ConcurrentReferenceHashMap.ReferenceType.SOFT, ConcurrentReferenceHashMap.ReferenceType.SOFT, EnumSet.noneOf(ConcurrentReferenceHashMap.Option.class));
        } else {
            this.resolvedMessages = null;
            this.tokenizedParameterMessages = null;
            this.tokenizedELMessages = null;
        }
        try {
            ResourceBundleMessageInterpolator.class.getClassLoader().loadClass("javax.el.ExpressionFactory");
        }
        catch (ClassNotFoundException e) {
            throw new ValidationException("Unable to load 'javax.el.ExpressionFactory'. Check that you have the EL dependencies on the classpath");
        }
    }

    @Override
    public String interpolate(String message, MessageInterpolator.Context context, ResourceBundleLocator validationResourceBundleLocator) {
        String interpolatedMessage = message;
        try {
            interpolatedMessage = this.interpolateMessage(message, context, validationResourceBundleLocator, this.defaultLocale);
        }
        catch (MessageDescriptorFormatException e) {
            log.warn((Object)e.getMessage());
        }
        return interpolatedMessage;
    }

    @Override
    public String interpolate(String message, MessageInterpolator.Context context, ResourceBundleLocator validationResourceBundleLocator, Locale locale) {
        String interpolatedMessage = message;
        try {
            interpolatedMessage = this.interpolateMessage(message, context, validationResourceBundleLocator, locale);
        }
        catch (ValidationException e) {
            log.warn((Object)e.getMessage());
        }
        return interpolatedMessage;
    }

    @Override
    public String interpolateBundleMessage(String message, ResourceBundleLocator validationResourceBundleLocator) {
        String interpolatedMessage = message;
        try {
            interpolatedMessage = this.interpolateMessage(message, validationResourceBundleLocator, this.defaultLocale);
        }
        catch (MessageDescriptorFormatException e) {
            log.warn((Object)e.getMessage());
        }
        return interpolatedMessage;
    }

    @Override
    public String interpolateBundleMessage(String message, ResourceBundleLocator validationResourceBundleLocator, Locale locale) {
        String interpolatedMessage = message;
        try {
            interpolatedMessage = this.interpolateMessage(message, validationResourceBundleLocator, locale);
        }
        catch (ValidationException e) {
            log.warn((Object)e.getMessage());
        }
        return interpolatedMessage;
    }

    private String interpolateMessage(String message, MessageInterpolator.Context context, ResourceBundleLocator validationResourceBundleLocator, Locale locale) throws MessageDescriptorFormatException {
        TokenCollector tokenCollector;
        String resolvedMessage = this.interpolateMessage(message, validationResourceBundleLocator, locale);
        List<Token> tokens = null;
        if (this.cachingEnabled) {
            tokens = this.tokenizedParameterMessages.get(resolvedMessage);
        }
        if (tokens == null) {
            tokenCollector = new TokenCollector(resolvedMessage, InterpolationTermType.PARAMETER);
            tokens = tokenCollector.getTokenList();
            if (this.cachingEnabled) {
                this.tokenizedParameterMessages.putIfAbsent(resolvedMessage, tokens);
            }
        }
        resolvedMessage = this.interpolateExpression(new TokenIterator(tokens), context, locale);
        tokens = null;
        if (this.cachingEnabled) {
            tokens = this.tokenizedELMessages.get(resolvedMessage);
        }
        if (tokens == null) {
            tokenCollector = new TokenCollector(resolvedMessage, InterpolationTermType.EL);
            tokens = tokenCollector.getTokenList();
            if (this.cachingEnabled) {
                this.tokenizedELMessages.putIfAbsent(resolvedMessage, tokens);
            }
        }
        resolvedMessage = this.interpolateExpression(new TokenIterator(tokens), context, locale);
        resolvedMessage = this.replaceEscapedLiterals(resolvedMessage);
        return resolvedMessage;
    }

    private String interpolateMessage(String message, ResourceBundleLocator validationResourceBundleLocator, Locale locale) throws MessageDescriptorFormatException {
        String cachedResolvedMessage;
        LocalizedMessage localisedMessage = new LocalizedMessage(message, locale);
        String resolvedMessage = null;
        if (this.cachingEnabled) {
            resolvedMessage = this.resolvedMessages.get(localisedMessage);
        }
        if (resolvedMessage == null) {
            ResourceBundle validationResourceBundle = validationResourceBundleLocator != null ? validationResourceBundleLocator.getResourceBundle(locale) : null;
            ResourceBundle userResourceBundle = this.userResourceBundleLocator.getResourceBundle(locale);
            ResourceBundle defaultResourceBundle = this.defaultResourceBundleLocator.getResourceBundle(locale);
            resolvedMessage = message;
            boolean evaluatedDefaultBundleOnce = false;
            while (true) {
                String userBundleResolvedMessage = this.interpolateBundleMessage(resolvedMessage, validationResourceBundle, locale, true);
                userBundleResolvedMessage = this.interpolateBundleMessage(userBundleResolvedMessage, userResourceBundle, locale, true);
                if (evaluatedDefaultBundleOnce && !this.hasReplacementTakenPlace(userBundleResolvedMessage, resolvedMessage)) break;
                resolvedMessage = this.interpolateBundleMessage(userBundleResolvedMessage, defaultResourceBundle, locale, false);
                evaluatedDefaultBundleOnce = true;
            }
        }
        if (this.cachingEnabled && (cachedResolvedMessage = this.resolvedMessages.putIfAbsent(localisedMessage, resolvedMessage)) != null) {
            resolvedMessage = cachedResolvedMessage;
        }
        return resolvedMessage;
    }

    private String replaceEscapedLiterals(String resolvedMessage) {
        resolvedMessage = resolvedMessage.replace("\\{", "{");
        resolvedMessage = resolvedMessage.replace("\\}", "}");
        resolvedMessage = resolvedMessage.replace("\\\\", "\\");
        resolvedMessage = resolvedMessage.replace("\\$", "$");
        return resolvedMessage;
    }

    private boolean hasReplacementTakenPlace(String origMessage, String newMessage) {
        return !origMessage.equals(newMessage);
    }

    private String interpolateBundleMessage(String message, ResourceBundle bundle, Locale locale, boolean recursive) throws MessageDescriptorFormatException {
        TokenCollector tokenCollector = new TokenCollector(message, InterpolationTermType.PARAMETER);
        TokenIterator tokenIterator = new TokenIterator(tokenCollector.getTokenList());
        while (tokenIterator.hasMoreInterpolationTerms()) {
            String term = tokenIterator.nextInterpolationTerm();
            String resolvedParameterValue = this.resolveParameter(term, bundle, locale, recursive);
            tokenIterator.replaceCurrentInterpolationTerm(resolvedParameterValue);
        }
        return tokenIterator.getInterpolatedMessage();
    }

    private String interpolateExpression(TokenIterator tokenIterator, MessageInterpolator.Context context, Locale locale) throws MessageDescriptorFormatException {
        while (tokenIterator.hasMoreInterpolationTerms()) {
            String term = tokenIterator.nextInterpolationTerm();
            InterpolationTerm expression = new InterpolationTerm(term, locale);
            String resolvedExpression = expression.interpolate(context);
            tokenIterator.replaceCurrentInterpolationTerm(resolvedExpression);
        }
        return tokenIterator.getInterpolatedMessage();
    }

    private String resolveParameter(String parameterName, ResourceBundle bundle, Locale locale, boolean recursive) throws MessageDescriptorFormatException {
        String parameterValue;
        try {
            if (bundle != null) {
                parameterValue = bundle.getString(this.removeCurlyBraces(parameterName));
                if (recursive) {
                    parameterValue = this.interpolateBundleMessage(parameterValue, bundle, locale, recursive);
                }
            } else {
                parameterValue = parameterName;
            }
        }
        catch (MissingResourceException e) {
            parameterValue = parameterName;
        }
        return parameterValue;
    }

    private String removeCurlyBraces(String parameter) {
        return parameter.substring(1, parameter.length() - 1);
    }
}

