/*
 * Decompiled with CFR 0.152.
 */
package org.devefx.validator.script;

import java.io.IOException;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.devefx.validator.beans.Container;
import org.devefx.validator.beans.factory.InitializingBean;
import org.devefx.validator.script.Handler;
import org.devefx.validator.script.handler.ExceptionHandler;
import org.devefx.validator.script.handler.NotFoundHandler;

public class UrlProcessor
implements InitializingBean {
    private static final Log log = LogFactory.getLog(UrlProcessor.class);
    protected Map<String, Handler> urlMapping = new HashMap<String, Handler>();
    protected NotFoundHandler notFoundHandler = new NotFoundHandler();
    protected ExceptionHandler exceptionHandler = new ExceptionHandler();

    @Override
    public void afterSetup(Container container) {
        Collection<Handler> handlers = container.getBeansOfType(Handler.class).values();
        for (Handler handler : handlers) {
            String path = handler.getPath();
            Handler previous = this.urlMapping.put(path, handler);
            if (previous == null) continue;
            throw new RuntimeException("the mapping already exists: " + path + "[" + handler + "]");
        }
    }

    public Map<String, Handler> getUrlMapping() {
        return this.urlMapping;
    }

    public void handle(HttpServletRequest request, HttpServletResponse response) throws IOException {
        try {
            String pathInfo = request.getPathInfo();
            if (pathInfo == null || pathInfo.length() == 0 || "/".equals(pathInfo)) {
                this.notFoundHandler.handle(request, response);
            } else {
                for (Map.Entry<String, Handler> entry : this.urlMapping.entrySet()) {
                    String url = entry.getKey();
                    if (!pathInfo.startsWith(url)) continue;
                    Handler handler = entry.getValue();
                    handler.handle(request, response);
                    return;
                }
                this.notFoundHandler.handle(request, response);
            }
        }
        catch (SecurityException se) {
            log.error((Object)"Security Exception: ", (Throwable)se);
            this.notFoundHandler.handle(request, response);
        }
        catch (Exception e) {
            this.exceptionHandler.setException(e);
            this.exceptionHandler.handle(request, response);
        }
    }
}

