/*
 * Decompiled with CFR 0.152.
 */
package org.devefx.validator.script.compressor;

import com.yahoo.platform.yui.compressor.JavaScriptCompressor;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.devefx.validator.script.Compressor;
import org.mozilla.javascript.ErrorReporter;
import org.mozilla.javascript.EvaluatorException;

public class YUICompressor
implements Compressor {
    private static final Log log = LogFactory.getLog(YUICompressor.class);
    private static final Integer DEFAULT_LINEBREAK = 20000;
    private int linebreak = DEFAULT_LINEBREAK;
    private boolean munge;
    private boolean verbose;
    private boolean preserveAllSemiColons;
    private boolean disableOptimizations;

    public YUICompressor() {
        this(DEFAULT_LINEBREAK, false, false, false, false);
    }

    public YUICompressor(int linebreak, boolean munge, boolean verbose, boolean preserveAllSemiColons, boolean disableOptimizations) {
        this.linebreak = linebreak;
        this.munge = munge;
        this.verbose = verbose;
        this.preserveAllSemiColons = preserveAllSemiColons;
        this.disableOptimizations = disableOptimizations;
    }

    public void setLinebreak(int linebreak) {
        this.linebreak = linebreak;
    }

    public void setMunge(boolean munge) {
        this.munge = munge;
    }

    public void setVerbose(boolean verbose) {
        this.verbose = verbose;
    }

    public void setPreserveAllSemiColons(boolean preserveAllSemiColons) {
        this.preserveAllSemiColons = preserveAllSemiColons;
    }

    public void setDisableOptimizations(boolean disableOptimizations) {
        this.disableOptimizations = disableOptimizations;
    }

    @Override
    public String compressJavaScript(String script) throws Exception {
        StringReader stringReader = new StringReader(script);
        JavaScriptCompressor javaScriptCompressor = new JavaScriptCompressor((Reader)stringReader, (ErrorReporter)new YUIErrorReporter());
        StringWriter stringWriter = new StringWriter();
        javaScriptCompressor.compress((Writer)stringWriter, this.linebreak, this.munge, this.verbose, this.preserveAllSemiColons, this.disableOptimizations);
        String compressedScript = stringWriter.toString();
        return compressedScript;
    }

    protected static class YUIErrorReporter
    implements ErrorReporter {
        protected YUIErrorReporter() {
        }

        public void warning(String message, String sourceName, int line, String lineSource, int lineOffset) {
            if (line < 0) {
                log.warn((Object)message);
            } else {
                log.error((Object)("\n" + line + ':' + lineOffset + ':' + message));
            }
        }

        public void error(String message, String sourceName, int line, String lineSource, int lineOffset) {
            if (line < 0) {
                log.error((Object)message);
            } else {
                log.error((Object)(String.valueOf(line + 58 + lineOffset + 58) + message));
            }
        }

        public EvaluatorException runtimeError(String message, String sourceName, int line, String lineSource, int lineOffset) {
            this.error(message, sourceName, line, lineSource, lineOffset);
            return new EvaluatorException(message);
        }
    }
}

