/*
 * Decompiled with CFR 0.152.
 */
package org.devefx.validator.script.handler;

import java.io.IOException;
import java.util.Locale;
import java.util.regex.Pattern;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.devefx.validator.beans.factory.annotation.Inject;
import org.devefx.validator.script.handler.JavaScriptHandler;
import org.devefx.validator.script.mapping.DefaultMappingManager;
import org.devefx.validator.util.ScriptUtil;

public abstract class BaseValidationHandler
extends JavaScriptHandler {
    protected final Log log = LogFactory.getLog(this.getClass());
    protected DefaultMappingManager mappingManager;

    @Inject
    public void setMappingManager(DefaultMappingManager mappingManager) {
        this.mappingManager = mappingManager;
    }

    @Override
    protected String generateJavaScript(String contextPath, String servletPath, String pathInfo, Locale locale) throws IOException {
        String scriptName = pathInfo;
        if (!scriptName.startsWith(this.getPath()) || !scriptName.endsWith(this.getSuffix())) {
            return null;
        }
        scriptName = scriptName.substring(this.getPath().length());
        if (!ScriptUtil.isValidScriptName(scriptName = scriptName.substring(0, scriptName.length() - this.getSuffix().length()))) {
            this.log.debug((Object)("Throwing at request for script with name: '" + scriptName + "'"));
            throw new SecurityException("Illegal script name.");
        }
        if (scriptName.contains("/")) {
            Pattern p = Pattern.compile(scriptName.replaceAll("/", "[/\\.]"));
            String match = null;
            for (String name : this.mappingManager.getMappingNames()) {
                if (!p.matcher(name).matches()) continue;
                if (match == null) {
                    match = name;
                    continue;
                }
                throw new IllegalArgumentException("Script name '" + scriptName + "' matches several validations.");
            }
            if (match != null) {
                scriptName = match;
            }
        }
        return this.generateValidationScript(contextPath, servletPath, scriptName, locale);
    }

    protected abstract String generateValidationScript(String var1, String var2, String var3, Locale var4);
}

