/*
 * Decompiled with CFR 0.152.
 */
package org.devefx.validator.script.handler;

import java.io.IOException;
import java.io.PrintWriter;
import java.util.Date;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.devefx.validator.beans.factory.annotation.Value;
import org.devefx.validator.internal.engine.messageinterpolation.LocalizedMessage;
import org.devefx.validator.script.Handler;

public abstract class CachingHandler
implements Handler {
    protected final Log log = LogFactory.getLog(this.getClass());
    public static final String DEFAULT_CONTENT_TYPE = "text/html;charset=ISO-8859-1";
    private boolean ignoreLastModified = false;
    private int periodCacheableTime = -1;
    private String contentType = "text/html;charset=ISO-8859-1";
    private String path;
    private final Map<LocalizedMessage, CachedResource> resourceCache = new HashMap<LocalizedMessage, CachedResource>();

    public void setIgnoreLastModified(boolean ignoreLastModified) {
        this.ignoreLastModified = ignoreLastModified;
    }

    @Value(value="${periodCacheableTime}")
    public void setPeriodCacheableTime(int periodCacheableTime) {
        this.periodCacheableTime = periodCacheableTime;
    }

    public int getPeriodCacheableTime() {
        return this.periodCacheableTime;
    }

    public void setContentType(String contentType) {
        this.contentType = contentType;
    }

    public String getContentType() {
        return this.contentType;
    }

    @Override
    public String getPath() {
        return this.path;
    }

    public void setPath(String path) {
        this.path = path;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void handle(HttpServletRequest request, HttpServletResponse response) throws IOException {
        CachedResource resource;
        long lastModified = this.getLastModifiedTime();
        if (this.isUpToDate(request, lastModified)) {
            response.setStatus(304);
            return;
        }
        Map<LocalizedMessage, CachedResource> map = this.resourceCache;
        synchronized (map) {
            String url = this.getCachingKey(request);
            Locale locale = this.getLocale(request);
            LocalizedMessage localizedMessage = new LocalizedMessage(url, locale);
            resource = this.resourceCache.get(localizedMessage);
            if (resource == null || lastModified > resource.lastModifiedTime) {
                if (this.log.isDebugEnabled()) {
                    if (resource == null) {
                        this.log.debug((Object)("Generating contents for " + url + ". It is not currently cached."));
                    } else {
                        this.log.debug((Object)("Generating contents for " + url + ". Resource modtime=" + lastModified + ". Cached modtime"));
                    }
                }
                resource = new CachedResource();
                resource.contents = this.generateCachableContent(request.getContextPath(), request.getServletPath(), request.getPathInfo(), locale);
                resource.lastModifiedTime = lastModified;
                this.resourceCache.put(localizedMessage, resource);
            }
        }
        this.addCacheHeaders(response);
        response.setContentType(this.getContentType());
        response.setDateHeader("Last-Modified", lastModified);
        response.setDateHeader("ETag", lastModified);
        if (resource.contents != null) {
            PrintWriter out = response.getWriter();
            out.write(resource.contents);
            out.flush();
        } else {
            response.sendError(404);
        }
    }

    protected Locale getLocale(HttpServletRequest request) {
        return Locale.getDefault();
    }

    protected void addCacheHeaders(HttpServletResponse response) {
        if (this.getPeriodCacheableTime() == 0) {
            this.addNoCacheHeaders(response);
            return;
        }
        int cacheSecs = this.getPeriodCacheableTime() < 0 ? 300 : this.getPeriodCacheableTime();
        long expiry = new Date().getTime() + (long)(cacheSecs * 1000);
        response.setHeader("Cache-Control", "public, max-age=" + cacheSecs);
        response.setDateHeader("Expires", expiry);
    }

    protected void addNoCacheHeaders(HttpServletResponse response) {
        response.setHeader("Cache-Control", "no-store, no-cache, must-revalidate");
        response.setHeader("Pragma", "no-cache");
        response.setDateHeader("Expires", 0L);
    }

    protected abstract long getLastModifiedTime();

    public abstract String generateCachableContent(String var1, String var2, String var3, Locale var4) throws IOException;

    protected boolean isUpToDate(HttpServletRequest req, long lastModified) {
        String etag = "\"" + lastModified + '\"';
        if (this.ignoreLastModified) {
            return false;
        }
        long modifiedSince = -1L;
        try {
            modifiedSince = req.getDateHeader("If-Modified-Since");
        }
        catch (RuntimeException runtimeException) {
            // empty catch block
        }
        if (modifiedSince != -1L) {
            modifiedSince -= modifiedSince % 1000L;
        }
        String givenEtag = req.getHeader("If-None-Match");
        String cachedPath = this.getCachingKey(req);
        if (givenEtag == null) {
            if (modifiedSince >= lastModified) {
                if (this.log.isDebugEnabled()) {
                    this.log.debug((Object)("Sending 304 for " + cachedPath + " If-Modified-Since=" + modifiedSince + ", Last-Modified=" + lastModified));
                }
                return true;
            }
            return false;
        }
        if (modifiedSince == -1L) {
            if (!etag.equals(givenEtag)) {
                if (this.log.isDebugEnabled()) {
                    this.log.debug((Object)("Sending 304 for " + cachedPath + ", If-Modified-Since=-1, Old ETag=" + givenEtag + ", New ETag=" + etag));
                }
                return true;
            }
            return false;
        }
        if (etag.equals(givenEtag) && modifiedSince >= lastModified) {
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)("Sending 304 for " + cachedPath + ", If-Modified-Since=" + modifiedSince + ", Last Modified=" + lastModified + ", Old ETag=" + givenEtag + ", New ETag=" + etag));
            }
            return true;
        }
        this.log.debug((Object)("Sending content for " + cachedPath + ", If-Modified-Since=" + modifiedSince + ", Last Modified=" + lastModified + ", Old ETag=" + givenEtag + ", New ETag=" + etag));
        return false;
    }

    protected String getCachingKey(HttpServletRequest request) {
        StringBuilder absolutePath = new StringBuilder();
        String scheme = request.getScheme();
        int port = request.getServerPort();
        absolutePath.append(scheme);
        absolutePath.append("://");
        absolutePath.append(request.getServerName());
        if (port > 0 && ("http".equalsIgnoreCase(scheme) && port != 80 || "https".equalsIgnoreCase(scheme) && port != 443)) {
            absolutePath.append(':');
            absolutePath.append(port);
        }
        absolutePath.append(request.getContextPath());
        absolutePath.append(request.getServletPath());
        if (request.getPathInfo() != null) {
            absolutePath.append(request.getPathInfo());
        }
        return absolutePath.toString();
    }

    class CachedResource {
        protected String contents;
        protected long lastModifiedTime;

        CachedResource() {
        }
    }
}

