/*
 * Decompiled with CFR 0.152.
 */
package org.devefx.validator.script.handler;

import java.io.File;
import java.io.IOException;
import java.lang.management.ManagementFactory;
import java.lang.management.RuntimeMXBean;
import java.net.URL;
import java.util.Locale;
import org.devefx.validator.script.handler.JavaScriptHandler;
import org.devefx.validator.util.ResourceUtils;

public class FileJavaScriptHandler
extends JavaScriptHandler {
    public static final String PATH_RESOURCE = "META-INF/resources/validatorjs";
    private final String resource;
    private final String copyright;

    public FileJavaScriptHandler(String resource) {
        this(resource, null);
    }

    public FileJavaScriptHandler(String resource, String copyright) {
        this.resource = resource;
        this.copyright = copyright;
    }

    @Override
    protected String generateJavaScript(String contextPath, String servletPath, String pathInfo, Locale locale) throws IOException {
        String javascript = ResourceUtils.getResourceAsString(this.resource);
        if (!this.debug && this.copyright != null) {
            javascript = String.valueOf(ResourceUtils.getResourceAsString(this.copyright)) + javascript;
        }
        return javascript;
    }

    @Override
    protected long getLastModifiedTime() {
        try {
            URL url = ResourceUtils.getResourceAsUrl(this.resource);
            if ("file".equals(url.getProtocol())) {
                File file = new File(url.getFile());
                return file.lastModified();
            }
        }
        catch (IOException url) {
            // empty catch block
        }
        RuntimeMXBean runtimeMXBean = ManagementFactory.getRuntimeMXBean();
        long startTime = runtimeMXBean.getStartTime();
        return startTime - startTime % 1000L;
    }
}

