/*
 * Decompiled with CFR 0.152.
 */
package org.devefx.validator.script.handler;

import java.io.IOException;
import java.util.Locale;
import org.devefx.validator.beans.factory.annotation.Inject;
import org.devefx.validator.beans.factory.annotation.Value;
import org.devefx.validator.script.Compressor;
import org.devefx.validator.script.handler.CachingHandler;

public abstract class JavaScriptHandler
extends CachingHandler {
    protected Compressor compressor;
    protected boolean debug;
    protected String suffix = "";

    public JavaScriptHandler() {
        this.setContentType("application/javascript;charset=UTF-8");
    }

    @Inject(required=false)
    public void setCompressor(Compressor compressor) {
        this.compressor = compressor;
    }

    @Value(value="${debug}")
    public void setDebug(boolean debug) {
        this.debug = debug;
    }

    public void setSuffix(String suffix) {
        this.suffix = suffix != null ? suffix : "";
    }

    protected String getSuffix() {
        return this.suffix;
    }

    @Override
    public String generateCachableContent(String contextPath, String servletPath, String pathInfo, Locale locale) throws IOException {
        String javascript = this.generateJavaScript(contextPath, servletPath, pathInfo, locale);
        if (this.debug || this.compressor == null || javascript == null) {
            return javascript;
        }
        try {
            return this.compressor.compressJavaScript(javascript);
        }
        catch (Exception ex) {
            if (this.log.isWarnEnabled()) {
                this.log.warn((Object)("Compression system (" + this.compressor.getClass().getSimpleName() + ") failed to compress script"), (Throwable)ex);
            }
            return javascript;
        }
    }

    protected abstract String generateJavaScript(String var1, String var2, String var3, Locale var4) throws IOException;
}

