/*
 * Decompiled with CFR 0.152.
 */
package org.devefx.validator.script.handler;

import java.io.IOException;
import java.io.PrintWriter;
import java.util.Locale;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.devefx.validator.ConstraintDescriptor;
import org.devefx.validator.ConstraintValidator;
import org.devefx.validator.ValidationContext;
import org.devefx.validator.beans.factory.annotation.Value;
import org.devefx.validator.http.reader.FormHttpMessageReader;
import org.devefx.validator.internal.util.ThreadContext;
import org.devefx.validator.script.NoFoundException;
import org.devefx.validator.script.handler.BaseValidationHandler;
import org.devefx.validator.script.mapping.Mapping;

public class RemoteValidateHandler
extends BaseValidationHandler {
    public static final String PARAMETER_ID = "id";
    public static final String PARAMETER_VALUE = "value";
    private FormHttpMessageReader reader = new FormHttpMessageReader();

    public RemoteValidateHandler() {
        this.setContentType("application/json;charset=UTF-8");
    }

    @Override
    @Value(value="${RemoteValidateHandler.path}")
    public void setPath(String path) {
        super.setPath(path);
    }

    @Override
    @Value(value="${RemoteValidateHandler.suffix}")
    public void setSuffix(String suffix) {
        super.setSuffix(suffix);
    }

    @Override
    public int getPeriodCacheableTime() {
        return 0;
    }

    @Override
    public void handle(HttpServletRequest request, HttpServletResponse response) throws IOException {
        String content = null;
        String scriptName = super.generateJavaScript(request.getContextPath(), request.getServletPath(), request.getPathInfo(), this.getLocale(request));
        if (scriptName != null) {
            try {
                boolean result = this.validateSingleConstraint(request, scriptName);
                content = String.valueOf(result);
            }
            catch (NoFoundException result) {
                // empty catch block
            }
        }
        if (content != null) {
            response.setContentType(this.getContentType());
            PrintWriter out = response.getWriter();
            out.write(content);
            out.flush();
        } else {
            response.sendError(404);
        }
    }

    @Override
    protected String generateValidationScript(String contextPath, String servletPath, String scriptName, Locale locale) {
        return scriptName;
    }

    protected boolean validateSingleConstraint(HttpServletRequest request, String name) throws NoFoundException {
        Object valueMap;
        Mapping mapping = this.mappingManager.getMapping(name);
        if (mapping == null) {
            throw new NoFoundException("not found mapping: " + name);
        }
        try {
            valueMap = this.reader.read((Class)null, request);
        }
        catch (Exception e) {
            this.log.error((Object)"Could not extract request.", (Throwable)e);
            return false;
        }
        String id = (String)valueMap.getFirst(PARAMETER_ID);
        ConstraintValidator validator = this.lookupConstraintValidator(mapping.getValidationContext(), id);
        if (validator == null) {
            throw new NoFoundException("not found constraint: " + id);
        }
        try {
            ThreadContext.bindModel(valueMap);
            Object value = valueMap.getFirst(PARAMETER_VALUE);
            boolean bl = validator.isValid(value);
            return bl;
        }
        catch (Exception e) {
            return false;
        }
        finally {
            ThreadContext.unbindModel();
        }
    }

    private ConstraintValidator lookupConstraintValidator(ValidationContext.Accessor context, String id) {
        for (ConstraintDescriptor descriptor : context.getConstraintDescriptors()) {
            ConstraintValidator constraintValidator = descriptor.getConstraintValidator();
            if (!Integer.toHexString(constraintValidator.hashCode()).equals(id)) continue;
            return constraintValidator;
        }
        return null;
    }

    @Override
    protected long getLastModifiedTime() {
        return 0L;
    }
}

