/*
 * Decompiled with CFR 0.152.
 */
package org.devefx.validator.script.mapping;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.devefx.validator.Validation;
import org.devefx.validator.beans.Container;
import org.devefx.validator.beans.factory.InitializingBean;
import org.devefx.validator.script.annotation.ScriptMapping;
import org.devefx.validator.script.mapping.Mapping;
import org.devefx.validator.script.mapping.MappingManager;
import org.devefx.validator.util.ScriptUtil;
import org.devefx.validator.util.StringUtils;

public class DefaultMappingManager
implements MappingManager,
InitializingBean {
    protected Map<String, Mapping> mappings = new HashMap<String, Mapping>();

    @Override
    public Collection<String> getMappingNames() {
        return this.mappings.keySet();
    }

    @Override
    public Mapping getMapping(String name) {
        return this.mappings.get(name);
    }

    @Override
    public void afterSetup(Container container) {
        Collection<Validation> validations = container.getBeansOfType(Validation.class).values();
        for (Validation validation : validations) {
            Class<?> validationClass = validation.getClass();
            ScriptMapping mapping = validationClass.getAnnotation(ScriptMapping.class);
            if (mapping == null) continue;
            String name = StringUtils.clean(mapping.value());
            if (name == null) {
                name = validationClass.getSimpleName();
            }
            this.addMapping(name, validationClass);
        }
    }

    public void addMapping(String name, Class<? extends Validation> validationClass) {
        if (!ScriptUtil.isValidScriptName(name)) {
            throw new IllegalArgumentException("Illegal mapping name.");
        }
        Mapping other = this.getMapping(name);
        if (other != null) {
            throw new IllegalArgumentException("mapping name " + name + " is used by 2 classes (" + other.getValidationClass() + " and " + validationClass + ")");
        }
        this.mappings.put(name, new Mapping(validationClass));
    }
}

