/*
 * Decompiled with CFR 0.152.
 */
package org.devefx.validator.spring;

import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import org.devefx.validator.beans.DefaultContainer;
import org.devefx.validator.spring.InitPropertyPlaceholderConfigurer;
import org.devefx.validator.util.ObjectUtils;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.ListableBeanFactory;

public class SpringContainer
extends DefaultContainer {
    private final BeanFactory beanFactory;

    public SpringContainer(BeanFactory beanFactory) {
        this.beanFactory = beanFactory;
    }

    @Override
    public Object getBean(String name) throws BeansException {
        Object bean;
        try {
            bean = this.beanFactory.getBean(name);
        }
        catch (BeansException e) {
            bean = super.getBean(name);
        }
        return bean;
    }

    @Override
    public <T> T getBean(String name, Class<T> requiredType) throws BeansException {
        Object bean;
        try {
            bean = this.beanFactory.getBean(name, requiredType);
        }
        catch (BeansException e) {
            bean = super.getBean(name, requiredType);
        }
        return (T)bean;
    }

    @Override
    public <T> T getBean(Class<T> requiredType) throws BeansException {
        Object bean;
        try {
            bean = this.beanFactory.getBean(requiredType);
        }
        catch (BeansException e) {
            bean = super.getBean(requiredType);
        }
        return (T)bean;
    }

    @Override
    public String[] getBeanNamesForType(Class<?> type) {
        Object[] array;
        String[] beanNames = super.getBeanNamesForType(type);
        if (this.beanFactory instanceof ListableBeanFactory && !ObjectUtils.isEmpty(array = ((ListableBeanFactory)this.beanFactory).getBeanNamesForType(type))) {
            HashSet<Object> uniqNames = new HashSet<Object>(beanNames.length);
            uniqNames.addAll(Arrays.asList(beanNames));
            uniqNames.addAll(Arrays.asList(array));
            beanNames = uniqNames.toArray(EMPTY_ARRAY);
        }
        return beanNames;
    }

    @Override
    public <T> Map<String, T> getBeansOfType(Class<T> type) {
        Map<String, T> beans = super.getBeansOfType(type);
        if (this.beanFactory instanceof ListableBeanFactory) {
            beans.putAll(((ListableBeanFactory)this.beanFactory).getBeansOfType(type));
        }
        return beans;
    }

    @Override
    public boolean containsBean(String name) {
        return this.beanFactory.containsBean(name) || super.containsBean(name);
    }

    @Override
    public String getProperty(String name) {
        Collection<InitPropertyPlaceholderConfigurer> configurers = this.getBeansOfType(InitPropertyPlaceholderConfigurer.class).values();
        for (InitPropertyPlaceholderConfigurer configurer : configurers) {
            String propValue = configurer.getProperty(name);
            if (propValue == null) continue;
            return propValue;
        }
        return super.getProperty(name);
    }
}

